/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.accessor;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class SuperConstructorAccessor
extends ExpressionAccessor {
    private final SuperConstructorInvocation m_invocation;
    private final int m_index;
    private final String m_defaultSource;

    public SuperConstructorAccessor(SuperConstructorInvocation invocation, int index, String defaultSource) {
        this.m_invocation = invocation;
        this.m_index = index;
        this.m_defaultSource = defaultSource;
    }

    public Expression getExpression(JavaInfo javaInfo) throws Exception {
        return DomGenerics.arguments(this.m_invocation).get(this.m_index);
    }

    public boolean setExpression(JavaInfo javaInfo, String source) throws Exception {
        Expression oldExpression;
        AstEditor editor;
        final String newSource = source != null ? source : this.m_defaultSource;
        if (newSource != null && !(editor = javaInfo.getEditor()).getSource((ASTNode)(oldExpression = this.getExpression(javaInfo))).equals(source)) {
            ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    editor.replaceExpression(oldExpression, newSource);
                }
            });
            return true;
        }
        return false;
    }
}

