/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.pattern;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenMappingGroup;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenPatternEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenRuntimeData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.ISegmentListener;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternSegmentStoreModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DataDrivenPattern
extends AbstractTmfStateProvider
implements IAnalysisDataContainer {
    private final DataDrivenPatternEventHandler fEventHandler;
    private final Map<String, DataDrivenMappingGroup> fMappingGroups = new HashMap<String, DataDrivenMappingGroup>();
    private final int fVersion;
    private final String fId;
    private final Map<String, ScriptEngine> fScriptEngine = new HashMap<String, ScriptEngine>();
    private final Map<Integer, TmfAttributePool> fAttributePools = new HashMap<Integer, TmfAttributePool>();
    private final ISegmentListener fListener;
    private final Map<String, String> fStoredFields;
    private final DataDrivenRuntimeData fExecutionData = new DataDrivenRuntimeData();

    public DataDrivenPattern(ITmfTrace trace, String providerId, int version, DataDrivenPatternEventHandler patternHandler, Collection<DataDrivenMappingGroup> mappingGroups, ISegmentListener listener, Map<String, String> storedFields) {
        super(trace, providerId);
        this.fEventHandler = patternHandler;
        mappingGroups.forEach(mg -> {
            DataDrivenMappingGroup dataDrivenMappingGroup = this.fMappingGroups.put(mg.getId(), (DataDrivenMappingGroup)mg);
        });
        this.fVersion = version;
        this.fId = providerId;
        this.fListener = listener;
        this.fStoredFields = storedFields;
    }

    @Override
    public ITmfStateSystem getStateSystem() {
        ITmfStateSystem ss = this.getAssignedStateSystem();
        if (ss == null) {
            throw new NullPointerException("The state system should not be requested at this point, it is null");
        }
        return ss;
    }

    @Override
    public @Nullable TmfAttributePool getAttributePool(int startNodeQuark) {
        ITmfStateSystem ss = this.getStateSystem();
        if (!(ss instanceof ITmfStateSystemBuilder)) {
            throw new IllegalStateException("The state system hasn't been initialized yet");
        }
        TmfAttributePool pool = this.fAttributePools.get(startNodeQuark);
        if (pool == null) {
            pool = new TmfAttributePool((ITmfStateSystemBuilder)ss, Integer.valueOf(startNodeQuark), TmfAttributePool.QueueType.PRIORITY);
            this.fAttributePools.put(startNodeQuark, pool);
        }
        return pool;
    }

    @Override
    public DataDrivenMappingGroup getMappingGroup(String id) {
        return Objects.requireNonNull(this.fMappingGroups.get(id));
    }

    public int getVersion() {
        return this.fVersion;
    }

    public ITmfStateProvider getNewInstance() {
        return new DataDrivenPattern(this.getTrace(), this.fId, this.fVersion, this.fEventHandler, this.fMappingGroups.values(), this.fListener, this.fStoredFields);
    }

    protected void eventHandle(ITmfEvent event) {
        this.fEventHandler.handleEvent(event, this, this.fExecutionData);
    }

    @Override
    public void setScriptengine(String name, ScriptEngine engine) {
        this.fScriptEngine.put(name, engine);
    }

    @Override
    public @Nullable ScriptEngine getScriptEngine(String name) {
        return this.fScriptEngine.get(name);
    }

    @Override
    public boolean isReadOnlyContainer() {
        return false;
    }

    public void dispose() {
        this.waitForEmptyQueue();
        this.fListener.onNewSegment(XmlPatternSegmentStoreModule.END_SEGMENT);
        this.fEventHandler.dispose(this.fExecutionData);
        super.dispose();
    }

    public ISegmentListener getListener() {
        return this.fListener;
    }

    public Map<String, String> getStoredFields() {
        return this.fStoredFields;
    }
}

