/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util.compression.huffmancoder;

import java.nio.ByteBuffer;
import org.eclipse.ptp.proxy.util.compression.IEncoder;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.ByteSymbolTable;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.HuffmanCoder;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.ISymbolDefiner;
import org.eclipse.ptp.proxy.util.messages.Messages;

public final class HuffmanByteCompress
implements IEncoder {
    private static final int NSYMBOLS = 256;
    private HuffmanCoder huffmanCoder;
    private ISymbolDefiner symbolTable;
    private boolean freqUpdated;
    private final int[] frequencies;
    private final int[] accFrequencies;
    private int bytesAccumulated;

    public HuffmanByteCompress() {
        this.symbolTable = new ByteSymbolTable();
        this.freqUpdated = true;
        this.frequencies = new int[256];
        this.accFrequencies = new int[256];
        int i = 0;
        while (i < this.frequencies.length) {
            this.accFrequencies[i] = 1;
            this.frequencies[i] = 1;
            ++i;
        }
        this.symbolTable = new ByteSymbolTable();
        this.huffmanCoder = new HuffmanCoder(this.symbolTable, this.frequencies);
        this.huffmanCoder.buildHuffmanTree();
        this.huffmanCoder.assignHuffmanCodes();
        this.freqUpdated = false;
        this.bytesAccumulated = 0;
    }

    public HuffmanByteCompress(int[] freq) {
        if (freq == null || freq.length != 256) {
            throw new IllegalArgumentException(Messages.getString("HuffmanByteCompress.0"));
        }
        this.frequencies = new int[256];
        this.accFrequencies = new int[256];
        System.arraycopy(freq, 0, this.frequencies, 0, 256);
        this.symbolTable = new ByteSymbolTable();
        this.huffmanCoder = new HuffmanCoder(this.symbolTable, this.frequencies);
        this.huffmanCoder.buildHuffmanTree();
        this.huffmanCoder.assignHuffmanCodes();
        this.freqUpdated = true;
        this.bytesAccumulated = 0;
        int i = 0;
        while (i < 256) {
            this.accFrequencies[i] = 1;
            ++i;
        }
    }

    private void accumulateFrequencies(ByteBuffer in) {
        byte[] b = in.array();
        int offset = in.arrayOffset();
        int limit = in.limit();
        int i = 0;
        while (i < limit) {
            int n = b[i + offset] & 0xFF;
            this.accFrequencies[n] = this.accFrequencies[n] + 1;
            ++i;
        }
        this.bytesAccumulated += limit;
    }

    public ByteBuffer apply(ByteBuffer in) {
        if (in == null || in.limit() <= 0) {
            throw new IllegalArgumentException(Messages.getString("HuffmanByteCompress.1"));
        }
        this.accumulateFrequencies(in);
        ByteBuffer encodedbuffer = this.huffmanCoder.encode(in);
        int len = encodedbuffer.limit() + (this.freqUpdated ? 1024 : 0) + 4;
        ByteBuffer result = ByteBuffer.allocate(len).putInt(in.limit());
        if (this.freqUpdated) {
            int[] nArray = this.frequencies;
            int n = this.frequencies.length;
            int n2 = 0;
            while (n2 < n) {
                int frequencie = nArray[n2];
                result.putInt(frequencie);
                ++n2;
            }
        }
        this.freqUpdated = false;
        result.put(encodedbuffer.array(), 0, encodedbuffer.limit()).rewind();
        return result;
    }

    public int getBytesAccumulated() {
        return this.bytesAccumulated;
    }

    public boolean getIncludeTableFlag() {
        return this.freqUpdated;
    }

    public void updateHuffmanTable() {
        this.symbolTable = new ByteSymbolTable();
        System.arraycopy(this.accFrequencies, 0, this.frequencies, 0, 256);
        int i = 0;
        while (i < 256) {
            this.accFrequencies[i] = 1;
            ++i;
        }
        this.huffmanCoder = new HuffmanCoder(this.symbolTable, this.frequencies);
        this.huffmanCoder.buildHuffmanTree();
        this.huffmanCoder.assignHuffmanCodes();
        this.freqUpdated = true;
        this.bytesAccumulated = 0;
    }

    public void updateHuffmanTable(int[] freq) {
        if (freq == null || freq.length != 256) {
            throw new IllegalArgumentException(Messages.getString("HuffmanByteCompress.0"));
        }
        System.arraycopy(freq, 0, this.frequencies, 0, 256);
        this.symbolTable = new ByteSymbolTable();
        this.huffmanCoder = new HuffmanCoder(this.symbolTable, this.frequencies);
        this.huffmanCoder.buildHuffmanTree();
        this.huffmanCoder.assignHuffmanCodes();
        this.freqUpdated = true;
        int i = 0;
        while (i < 256) {
            this.accFrequencies[i] = 1;
            ++i;
        }
        this.bytesAccumulated = 0;
    }
}

