/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.binary;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.Relations;
import org.eclipse.emf.diffmerge.structures.binary.AbstractBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.IRangedBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;

public class HashBinaryRelation<T, U>
extends AbstractBinaryRelation<T, U>
implements IRangedBinaryRelation.Editable<T, U> {
    private final EMap<T, Collection<U>> _contents = this.newContents();

    public HashBinaryRelation() {
        this(null);
    }

    public HashBinaryRelation(IEqualityTester tester_p) {
        super(tester_p);
    }

    @Override
    public boolean add(T source_p, U target_p) {
        assert (source_p != null && target_p != null);
        boolean result = false;
        Collection<U> values = (Collection<U>)this.getContents().get(source_p);
        if (values == null) {
            values = this.newTargetCollection();
            this.getContents().put(source_p, values);
        }
        result = values.add(target_p);
        return result;
    }

    @Override
    public boolean addAll(T source_p, Collection<? extends U> targets_p) {
        assert (source_p != null && targets_p != null);
        boolean result = false;
        if (!targets_p.isEmpty()) {
            Collection<U> values = (Collection<U>)this.getContents().get(source_p);
            if (values == null) {
                values = this.newTargetCollection();
                this.getContents().put(source_p, values);
            }
            result = values.addAll(targets_p);
        }
        return result;
    }

    @Override
    public void clear() {
        this.getContents().clear();
    }

    @Override
    public Collection<U> get(T element_p) {
        assert (element_p != null);
        Collection values = (Collection)this.getContents().get(element_p);
        Collection result = values == null ? Collections.emptyList() : Collections.unmodifiableCollection(values);
        return result;
    }

    protected EMap<T, Collection<U>> getContents() {
        return this._contents;
    }

    @Override
    public Collection<T> getSources() {
        return Collections.unmodifiableSet(this.getContents().keySet());
    }

    @Override
    public Collection<U> getTargets() {
        FHashSet result = new FHashSet(this.getEqualityTester());
        for (Collection valueList : this.getContents().values()) {
            result.addAll(valueList);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public boolean isEmpty() {
        return this.getContents().isEmpty();
    }

    @Override
    public IPropertyValue<Boolean> isFunctional() {
        boolean result = Relations.rangedIsFunctional(this);
        return PropertyValue.valueOf(result);
    }

    @Override
    public IPropertyValue<Boolean> isInjective() {
        FHashSet targets = new FHashSet(this.getEqualityTester());
        for (Collection valueList : this.getContents().values()) {
            for (Object value : valueList) {
                boolean added = targets.add(value);
                if (added) continue;
                return PropertyValue.falseValue();
            }
        }
        return PropertyValue.trueValue();
    }

    protected EMap<T, Collection<U>> newContents() {
        return new FHashMap(this.getEqualityTester());
    }

    protected Collection<U> newTargetCollection() {
        return new FHashSet(this.getEqualityTester());
    }

    @Override
    public boolean remove(T source_p, U target_p) {
        assert (source_p != null && target_p != null);
        boolean result = false;
        Collection values = (Collection)this.getContents().get(source_p);
        if (values != null) {
            result = values.remove(target_p);
            if (values.isEmpty()) {
                this.getContents().removeKey(source_p);
            }
        }
        return result;
    }

    @Override
    public boolean removeSource(T source_p) {
        assert (source_p != null);
        Collection values = (Collection)this.getContents().removeKey(source_p);
        boolean result = values != null;
        return result;
    }

    @Override
    public boolean removeTarget(U target_p) {
        boolean result = false;
        FArrayList<T> sources = new FArrayList<T>(this.getSources(), this.getEqualityTester());
        Iterator iterator = sources.iterator();
        while (iterator.hasNext()) {
            Object source = iterator.next();
            boolean justRemoved = this.remove(source, target_p);
            boolean bl = result = result || justRemoved;
        }
        return result;
    }
}

