/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal.miniunit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.debug.ui.console.RubyConsoleSourceModuleLookup;
import org.eclipse.dltk.ruby.testing.internal.AbstractRubyTestRunnerUI;
import org.eclipse.dltk.ruby.testing.internal.AbstractRubyTestingEngine;
import org.eclipse.dltk.ruby.testing.internal.ResolverUtils;
import org.eclipse.dltk.ruby.testing.internal.RubyTestingPlugin;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.TestElementResolution;
import org.eclipse.dltk.testing.model.ITestCaseElement;
import org.eclipse.dltk.testing.model.ITestSuiteElement;
import org.eclipse.osgi.util.NLS;

public class MiniTestRunnerUI
extends AbstractRubyTestRunnerUI {
    private static final char CLASS_BEGIN = '(';
    private static final char CLASS_END = ')';
    private static final String[] TEST_UNIT = new String[]{"test", "unit"};

    public MiniTestRunnerUI(AbstractRubyTestingEngine testingEngine, IScriptProject project) {
        super(testingEngine, project);
    }

    public String getTestCaseLabel(ITestCaseElement caseElement, boolean full) {
        String testName = caseElement.getTestName();
        int index = testName.lastIndexOf(40);
        if (index > 0) {
            int braceIndex = index;
            while (index > 0 && Character.isWhitespace(testName.charAt(index - 1))) {
                --index;
            }
            if (full) {
                int end = testName.length();
                if (end > braceIndex + 1 && testName.charAt(end - 1) == ')') {
                    --end;
                }
                String template = DLTKTestingMessages.TestSessionLabelProvider_testMethodName_className;
                return NLS.bind((String)template, (Object)testName.substring(braceIndex + 1, end), (Object)testName.substring(0, index));
            }
            return testName.substring(0, index);
        }
        return testName;
    }

    public String getTestStartedMessage(ITestCaseElement caseElement) {
        String testName = caseElement.getTestName();
        int index = testName.lastIndexOf(40);
        if (index > 0) {
            int end = testName.length();
            if (end > index && testName.charAt(end - 1) == ')') {
                --end;
            }
            String className = testName.substring(index + 1, end);
            while (index > 0 && Character.isWhitespace(testName.charAt(index - 1))) {
                --index;
            }
            String method = testName.substring(0, index);
            return NLS.bind((String)DLTKTestingMessages.TestRunnerViewPart_message_started, (Object)className, (Object)method);
        }
        return testName;
    }

    @Override
    protected TestElementResolution resolveTestCase(ITestCaseElement testCase) {
        IMethod method;
        String testName = testCase.getTestName();
        if (testName.length() == 0) {
            return null;
        }
        int pos = testName.lastIndexOf(40);
        if (pos <= 0 || testName.charAt(testName.length() - 1) != ')') {
            return null;
        }
        String className = testName.substring(pos + 1, testName.length() - 1);
        if (!RubySyntaxUtils.isValidClass((String)className)) {
            return null;
        }
        String methodName = testName.substring(0, pos).trim();
        if (RubySyntaxUtils.isRubyMethodName((String)methodName) && (method = this.findMethod(className, methodName)) != null) {
            return new TestElementResolution((IModelElement)method, ResolverUtils.getSourceRange((IMember)method));
        }
        List<IType> types = this.findClasses(className);
        if (types == null) {
            return null;
        }
        return null;
    }

    @Override
    protected TestElementResolution resolveTestSuite(ITestSuiteElement element) {
        List<IType> types;
        String className = element.getSuiteTypeName();
        if (RubySyntaxUtils.isValidClass((String)className) && (types = this.findClasses(className)) != null) {
            IType type = types.get(0);
            return new TestElementResolution((IModelElement)type, ResolverUtils.getSourceRange((IMember)type));
        }
        return null;
    }

    private IMethod findMethod(String className, String methodName) {
        IDLTKSearchScope scope = this.getSearchScope();
        String sPattern = String.valueOf(className) + "::" + methodName;
        SearchPattern pattern = SearchPattern.createPattern((String)sPattern, (int)1, (int)0, (int)8, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        try {
            MethodRequestor requestor = new MethodRequestor();
            new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
            return requestor.method;
        }
        catch (CoreException e) {
            String msg = "Error in findMethod({0}::{1})";
            RubyTestingPlugin.error(NLS.bind((String)"Error in findMethod({0}::{1})", (Object)className, (Object)methodName), e);
            return null;
        }
    }

    private List<IType> findClasses(String className) {
        IDLTKSearchScope scope = this.getSearchScope();
        SearchPattern pattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)8, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        try {
            TypeSearchRequestor requestor = new TypeSearchRequestor();
            new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
            if (!requestor.types.isEmpty()) {
                return requestor.types;
            }
        }
        catch (CoreException e) {
            String msg = "Error in findClasses({0})";
            RubyTestingPlugin.error(NLS.bind((String)"Error in findClasses({0})", (Object)className), e);
        }
        return null;
    }

    private boolean testFragmentPath(IPath fragmentPath, IPath path) {
        if (this.pathEquality.isPrefixOf(fragmentPath, path) && path.segmentCount() > fragmentPath.segmentCount() + TEST_UNIT.length) {
            int j = 0;
            while (j < TEST_UNIT.length) {
                if (!TEST_UNIT[j].equals(path.segment(fragmentPath.segmentCount() + j))) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean selectLine(String line) {
        String filename = this.extractFileName(line);
        if (filename == null) {
            return true;
        }
        if (filename.endsWith("dltk-minitest-runner.rb")) {
            return false;
        }
        Path path = new Path(filename);
        try {
            IProjectFragment[] fragments = this.project.getProjectFragments();
            int i = 0;
            while (true) {
                if (i >= fragments.length) {
                    return true;
                }
                IProjectFragment fragment = fragments[i];
                if (fragment.isExternal() && this.testFragmentPath(EnvironmentPathUtils.getLocalPath((IPath)fragment.getPath()), (IPath)path) && RubyConsoleSourceModuleLookup.isIncluded((IProjectFragment)fragment, (IPath)path)) {
                    return false;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            return true;
        }
    }

    private static final class MethodRequestor
    extends SearchRequestor {
        IMethod method = null;

        private MethodRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.method = (IMethod)match.getElement();
        }
    }

    private static final class TypeSearchRequestor
    extends SearchRequestor {
        final List<IType> types = new ArrayList<IType>();

        private TypeSearchRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.types.add((IType)match.getElement());
        }
    }
}

