/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearch.config;

import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchIndex;
import org.eclipse.rdf4j.sail.elasticsearch.config.ElasticsearchSailConfig;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.lucene.config.AbstractLuceneSailConfig;

public class ElasticsearchSailFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:LuceneSail/Elasticsearch";

    public String getSailType() {
        return SAIL_TYPE;
    }

    public SailImplConfig getConfig() {
        return new ElasticsearchSailConfig();
    }

    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        LuceneSail luceneSail = new LuceneSail();
        luceneSail.setParameter("index", ElasticsearchIndex.class.getName());
        if (config instanceof AbstractLuceneSailConfig) {
            AbstractLuceneSailConfig luceneConfig = (AbstractLuceneSailConfig)config;
            luceneSail.setParameter("lucenedir", luceneConfig.getIndexDir());
            for (String key : luceneConfig.getParameterNames()) {
                luceneSail.setParameter(key, luceneConfig.getParameter(key));
            }
        }
        return luceneSail;
    }
}

