/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.protocol.transaction;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.rdf4j.common.xml.XMLUtil;
import org.eclipse.rdf4j.common.xml.XMLWriter;
import org.eclipse.rdf4j.http.protocol.transaction.operations.AddStatementOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.ClearNamespacesOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.ClearOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.RemoveNamespaceOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.RemoveStatementsOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.SPARQLUpdateOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.SetNamespaceOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.StatementOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.TransactionOperation;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.rio.helpers.RDFStarUtil;

public class TransactionWriter {
    public void serialize(Iterable<? extends TransactionOperation> txn, OutputStream out) throws IOException {
        assert (txn != null) : "operation list must not be null";
        assert (out != null) : "output stream must not be null";
        XMLWriter xmlWriter = new XMLWriter(out);
        xmlWriter.setPrettyPrint(true);
        xmlWriter.startDocument();
        xmlWriter.startTag("transaction");
        for (TransactionOperation transactionOperation : txn) {
            this.serialize(transactionOperation, xmlWriter);
        }
        xmlWriter.endTag("transaction");
        xmlWriter.endDocument();
    }

    protected void serialize(TransactionOperation op, XMLWriter xmlWriter) throws IOException {
        if (op instanceof AddStatementOperation) {
            this.serialize((AddStatementOperation)op, xmlWriter);
        } else if (op instanceof RemoveStatementsOperation) {
            this.serialize((RemoveStatementsOperation)op, xmlWriter);
        } else if (op instanceof ClearOperation) {
            this.serialize((ClearOperation)op, xmlWriter);
        } else if (op instanceof SetNamespaceOperation) {
            this.serialize((SetNamespaceOperation)op, xmlWriter);
        } else if (op instanceof RemoveNamespaceOperation) {
            this.serialize((RemoveNamespaceOperation)op, xmlWriter);
        } else if (op instanceof ClearNamespacesOperation) {
            this.serialize((ClearNamespacesOperation)op, xmlWriter);
        } else if (op instanceof SPARQLUpdateOperation) {
            this.serialize((SPARQLUpdateOperation)op, xmlWriter);
        } else if (op != null) {
            throw new IllegalArgumentException("Unknown operation type: " + String.valueOf(op.getClass()));
        }
    }

    protected void serialize(AddStatementOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.startTag("add");
        this.serialize((StatementOperation)op, xmlWriter);
        xmlWriter.endTag("add");
    }

    protected void serialize(SPARQLUpdateOperation op, XMLWriter xmlWriter) throws IOException {
        String baseURI = op.getBaseURI();
        if (baseURI != null) {
            xmlWriter.setAttribute("baseURI", baseURI);
        }
        xmlWriter.setAttribute("includeInferred", op.isIncludeInferred());
        xmlWriter.startTag("sparql");
        String updateString = op.getUpdateString();
        xmlWriter.textElement("updateString", updateString);
        Dataset dataset = op.getDataset();
        if (dataset != null) {
            xmlWriter.startTag("dataset");
            xmlWriter.startTag("defaultGraphs");
            for (IRI defaultGraph : dataset.getDefaultGraphs()) {
                xmlWriter.textElement("graph", defaultGraph.stringValue());
            }
            xmlWriter.endTag("defaultGraphs");
            xmlWriter.startTag("namedGraphs");
            for (IRI namedGraph : dataset.getNamedGraphs()) {
                xmlWriter.textElement("graph", namedGraph.stringValue());
            }
            xmlWriter.endTag("namedGraphs");
            xmlWriter.startTag("defaultRemoveGraphs");
            for (IRI defaultRemoveGraph : dataset.getDefaultRemoveGraphs()) {
                xmlWriter.textElement("graph", defaultRemoveGraph.stringValue());
            }
            xmlWriter.endTag("defaultRemoveGraphs");
            if (dataset.getDefaultInsertGraph() != null) {
                xmlWriter.textElement("defaultInsertGraph", dataset.getDefaultInsertGraph().stringValue());
            }
            xmlWriter.endTag("dataset");
        }
        if (op.getBindings() != null && op.getBindings().length > 0) {
            xmlWriter.startTag("bindings");
            for (Binding binding : op.getBindings()) {
                if (binding.getName() == null || binding.getValue() == null || binding.getValue().stringValue() == null) continue;
                if (binding.getValue() instanceof IRI) {
                    xmlWriter.setAttribute("name", binding.getName());
                    xmlWriter.textElement("binding_uri", binding.getValue().stringValue());
                }
                if (binding.getValue() instanceof BNode) {
                    xmlWriter.setAttribute("name", binding.getName());
                    xmlWriter.textElement("binding_bnode", binding.getValue().stringValue());
                }
                if (!(binding.getValue() instanceof Literal)) continue;
                xmlWriter.setAttribute("name", binding.getName());
                Literal literal = (Literal)binding.getValue();
                if (Literals.isLanguageLiteral((Literal)literal)) {
                    xmlWriter.setAttribute("language", (String)literal.getLanguage().get());
                } else {
                    xmlWriter.setAttribute("dataType", literal.getDatatype().stringValue());
                }
                xmlWriter.textElement("binding_literal", binding.getValue().stringValue());
            }
            xmlWriter.endTag("bindings");
        }
        xmlWriter.endTag("sparql");
    }

    protected void serialize(RemoveStatementsOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.startTag("remove");
        this.serialize((StatementOperation)op, xmlWriter);
        xmlWriter.endTag("remove");
    }

    protected void serialize(StatementOperation op, XMLWriter xmlWriter) throws IOException {
        this.serialize(op.getSubject(), xmlWriter);
        this.serialize(op.getPredicate(), xmlWriter);
        this.serialize(op.getObject(), xmlWriter);
        this.serialize(op.getContexts(), xmlWriter);
    }

    protected void serialize(ClearOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.startTag("clear");
        this.serialize(op.getContexts(), xmlWriter);
        xmlWriter.endTag("clear");
    }

    protected void serialize(SetNamespaceOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.setAttribute("prefix", op.getPrefix());
        xmlWriter.setAttribute("name", op.getName());
        xmlWriter.emptyElement("setNamespace");
    }

    protected void serialize(RemoveNamespaceOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.setAttribute("prefix", op.getPrefix());
        xmlWriter.emptyElement("removeNamespace");
    }

    protected void serialize(ClearNamespacesOperation op, XMLWriter xmlWriter) throws IOException {
        xmlWriter.emptyElement("clearNamespaces");
    }

    protected void serialize(Resource[] contexts, XMLWriter xmlWriter) throws IOException {
        if (contexts.length > 0) {
            xmlWriter.startTag("contexts");
            for (Resource context : contexts) {
                this.serialize(context, xmlWriter);
            }
            xmlWriter.endTag("contexts");
        } else {
            xmlWriter.emptyElement("contexts");
        }
    }

    protected void serialize(Value value, XMLWriter xmlWriter) throws IOException {
        if (value instanceof Resource) {
            this.serialize((Resource)value, xmlWriter);
        } else if (value instanceof Literal) {
            this.serialize((Literal)value, xmlWriter);
        } else if (value == null) {
            this.serializeNull(xmlWriter);
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass().toString());
        }
    }

    protected void serialize(Resource resource, XMLWriter xmlWriter) throws IOException {
        if (resource instanceof IRI) {
            this.serialize((IRI)resource, xmlWriter);
        } else if (resource instanceof BNode) {
            this.serialize((BNode)resource, xmlWriter);
        } else if (resource instanceof Triple) {
            this.serialize((Triple)resource, xmlWriter);
        } else if (resource == null) {
            this.serializeNull(xmlWriter);
        } else {
            throw new IllegalArgumentException("Unknown resource type: " + resource.getClass().toString());
        }
    }

    protected void serialize(IRI uri, XMLWriter xmlWriter) throws IOException {
        if (uri != null) {
            xmlWriter.textElement("uri", uri.toString());
        } else {
            this.serializeNull(xmlWriter);
        }
    }

    protected void serialize(BNode bnode, XMLWriter xmlWriter) throws IOException {
        if (bnode != null) {
            xmlWriter.textElement("bnode", bnode.getID());
        } else {
            this.serializeNull(xmlWriter);
        }
    }

    protected void serialize(Literal literal, XMLWriter xmlWriter) throws IOException {
        if (literal != null) {
            if (Literals.isLanguageLiteral((Literal)literal)) {
                xmlWriter.setAttribute("xml:lang", (String)literal.getLanguage().get());
            } else {
                xmlWriter.setAttribute("datatype", literal.getDatatype().toString());
            }
            String label = literal.getLabel();
            boolean valid = true;
            int i = 0;
            while (valid && i < label.length()) {
                char c = label.charAt(i++);
                valid = XMLUtil.isValidCharacterDataChar((char)c);
            }
            if (!valid) {
                xmlWriter.setAttribute("encoding", "base64");
                label = Base64.getEncoder().encodeToString(label.getBytes(StandardCharsets.UTF_8));
            }
            xmlWriter.textElement("literal", label);
        } else {
            this.serializeNull(xmlWriter);
        }
    }

    protected void serializeNull(XMLWriter xmlWriter) throws IOException {
        xmlWriter.emptyElement("null");
    }

    protected void serialize(Triple triple, XMLWriter xmlWriter) throws IOException {
        if (triple != null) {
            Value convertBase64 = RDFStarUtil.toRDFEncodedValue((Value)triple);
            xmlWriter.textElement("triple", convertBase64.stringValue());
        } else {
            this.serializeNull(xmlWriter);
        }
    }
}

