/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.factory.set.MultiReaderSetFactory;
import org.eclipse.collections.api.set.MultiReaderSet;
import org.eclipse.collections.impl.set.mutable.MultiReaderUnifiedSet;

public enum MultiReaderMutableSetFactory implements MultiReaderSetFactory
{
    INSTANCE;


    public <T> MultiReaderSet<T> empty() {
        return MultiReaderUnifiedSet.newSet();
    }

    public <T> MultiReaderSet<T> with(T ... items) {
        return MultiReaderUnifiedSet.newSetWith(items);
    }

    public <T> MultiReaderSet<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return MultiReaderUnifiedSet.newSet(capacity);
    }

    public <T> MultiReaderSet<T> withAll(Iterable<? extends T> iterable) {
        return MultiReaderUnifiedSet.newSet(iterable);
    }

    public <T> MultiReaderSet<T> fromStream(Stream<? extends T> stream) {
        return stream.collect(Collectors.toCollection(MultiReaderUnifiedSet::newSet));
    }
}

