/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class TrimToTarget
implements PlanNode {
    private StackTraceElement[] stackTrace;
    PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;
    boolean keepPath = false;

    public TrimToTarget(PlanNode parent, ConnectionsGroup connectionsGroup) {
        this.parent = PlanNodeHelper.handleSorting(this, parent, connectionsGroup);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private CloseableIteration<? extends ValidationTuple> parentIterator;

            @Override
            protected void init() {
                this.parentIterator = TrimToTarget.this.parent.iterator();
            }

            @Override
            public void localClose() {
                if (this.parentIterator != null) {
                    this.parentIterator.close();
                }
            }

            @Override
            protected boolean localHasNext() {
                return this.parentIterator.hasNext();
            }

            @Override
            protected ValidationTuple loggingNext() {
                return ((ValidationTuple)this.parentIterator.next()).trimToTarget();
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrimToTarget that = (TrimToTarget)o;
        return this.keepPath == that.keepPath && this.parent.equals(that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.keepPath);
    }

    public String toString() {
        return "TrimToTarget{keepPath=" + this.keepPath + "}";
    }
}

