/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.UnmodifiableModel;

public abstract class AbstractModel
extends AbstractSet<Statement>
implements Model {
    private static final long serialVersionUID = 4254119331281455614L;
    public static final Resource[] NULL_CONTEXT = new Resource[]{null};

    public Model unmodifiable() {
        return new UnmodifiableModel(this);
    }

    @Override
    public boolean add(Statement st) {
        return this.add(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[]{st.getContext()});
    }

    @Override
    public boolean isEmpty() {
        return !this.contains(null, null, null, new Resource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeIterator(c, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        if (this.size() > c.size()) {
            Iterator<?> i = c.iterator();
            try {
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            }
            finally {
                this.closeIterator(c, i);
            }
        }
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
        }
        finally {
            this.closeIterator(i);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Iterator it = this.iterator();
        try {
            ArrayList r = new ArrayList(this.size());
            while (it.hasNext()) {
                r.add(it.next());
            }
            Object[] objectArray = r.toArray();
            return objectArray;
        }
        finally {
            this.closeIterator(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Iterator it = this.iterator();
        try {
            ArrayList r = new ArrayList(this.size());
            while (it.hasNext()) {
                r.add(it.next());
            }
            T[] TArray = r.toArray(a);
            return TArray;
        }
        finally {
            this.closeIterator(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends Statement> c) {
        Iterator<? extends Statement> e = c.iterator();
        try {
            boolean modified = false;
            while (e.hasNext()) {
                if (!this.add(e.next())) continue;
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeIterator(c, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator e = this.iterator();
        try {
            boolean modified = false;
            while (e.hasNext()) {
                if (c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeIterator(e);
        }
    }

    @Override
    public void clear() {
        this.remove(null, null, null, new Resource[0]);
    }

    public boolean clear(Resource ... contexts) {
        return this.remove(null, null, null, contexts);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Statement) {
            if (this.isEmpty()) {
                return false;
            }
            Statement st = (Statement)o;
            return this.remove(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[]{st.getContext()});
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Statement) {
            Statement st = (Statement)o;
            if (st.getContext() == null) {
                return this.contains(st.getSubject(), st.getPredicate(), st.getObject(), NULL_CONTEXT);
            }
            return this.contains(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[]{st.getContext()});
        }
        return false;
    }

    public Set<Resource> subjects() {
        return new ValueSet<Resource>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof Resource) {
                    return AbstractModel.this.contains((Resource)o, null, null, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Resource) {
                    return AbstractModel.this.remove((Resource)o, null, null, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean add(Resource subj) {
                return AbstractModel.this.add(subj, null, null, new Resource[0]);
            }

            @Override
            protected Resource term(Statement st) {
                return st.getSubject();
            }

            @Override
            protected void removeIteration(Iterator<Statement> iter, Resource subj) {
                AbstractModel.this.removeTermIteration(iter, subj, null, null, new Resource[0]);
            }
        };
    }

    public Set<IRI> predicates() {
        return new ValueSet<IRI>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof IRI) {
                    return AbstractModel.this.contains(null, (IRI)o, null, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof IRI) {
                    return AbstractModel.this.remove(null, (IRI)o, null, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean add(IRI pred) {
                return AbstractModel.this.add(null, pred, null, new Resource[0]);
            }

            @Override
            protected IRI term(Statement st) {
                return st.getPredicate();
            }

            @Override
            protected void removeIteration(Iterator<Statement> iter, IRI pred) {
                AbstractModel.this.removeTermIteration(iter, null, pred, null, new Resource[0]);
            }
        };
    }

    public Set<Value> objects() {
        return new ValueSet<Value>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof Value) {
                    return AbstractModel.this.contains(null, null, (Value)o, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Value) {
                    return AbstractModel.this.remove(null, null, (Value)o, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean add(Value obj) {
                return AbstractModel.this.add(null, null, obj, new Resource[0]);
            }

            @Override
            protected Value term(Statement st) {
                return st.getObject();
            }

            @Override
            protected void removeIteration(Iterator<Statement> iter, Value obj) {
                AbstractModel.this.removeTermIteration(iter, null, null, obj, new Resource[0]);
            }
        };
    }

    public Set<Resource> contexts() {
        return new ValueSet<Resource>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof Resource || o == null) {
                    return AbstractModel.this.contains(null, null, null, new Resource[]{(Resource)o});
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Resource || o == null) {
                    return AbstractModel.this.remove(null, null, null, new Resource[]{(Resource)o});
                }
                return false;
            }

            @Override
            public boolean add(Resource context) {
                return AbstractModel.this.add(null, null, null, new Resource[]{context});
            }

            @Override
            protected Resource term(Statement st) {
                return st.getContext();
            }

            @Override
            protected void removeIteration(Iterator<Statement> iter, Resource term) {
                AbstractModel.this.removeTermIteration(iter, null, null, null, term);
            }
        };
    }

    public abstract void removeTermIteration(Iterator<Statement> var1, Resource var2, IRI var3, Value var4, Resource ... var5);

    protected void closeIterator(Iterator<?> iter) {
        if (iter instanceof ValueSet.ValueSetIterator) {
            this.closeIterator(((ValueSet.ValueSetIterator)iter).iter);
        }
    }

    private void closeIterator(Collection<?> c, Iterator<?> e) {
        if (c instanceof AbstractModel) {
            ((AbstractModel)c).closeIterator(e);
        } else if (c instanceof ValueSet) {
            ((ValueSet)c).closeIterator(e);
        }
    }

    private abstract class ValueSet<V extends Value>
    extends AbstractSet<V> {
        private ValueSet() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueSetIterator(AbstractModel.this.iterator());
        }

        @Override
        public void clear() {
            AbstractModel.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return AbstractModel.this.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Iterator iter = AbstractModel.this.iterator();
            try {
                LinkedHashSet<V> set = new LinkedHashSet<V>();
                while (iter.hasNext()) {
                    set.add(this.term((Statement)iter.next()));
                }
                int n = set.size();
                return n;
            }
            finally {
                AbstractModel.this.closeIterator(iter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator<?> i = c.iterator();
            try {
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            }
            finally {
                this.closeIterator(c, i);
            }
            return modified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Iterator iter = AbstractModel.this.iterator();
            try {
                LinkedHashSet<V> set = new LinkedHashSet<V>();
                while (iter.hasNext()) {
                    set.add(this.term((Statement)iter.next()));
                }
                Object[] objectArray = set.toArray();
                return objectArray;
            }
            finally {
                AbstractModel.this.closeIterator(iter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Iterator iter = AbstractModel.this.iterator();
            try {
                LinkedHashSet<V> set = new LinkedHashSet<V>();
                while (iter.hasNext()) {
                    set.add(this.term((Statement)iter.next()));
                }
                T[] TArray = set.toArray(a);
                return TArray;
            }
            finally {
                AbstractModel.this.closeIterator(iter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Iterator<?> e = c.iterator();
            try {
                while (e.hasNext()) {
                    if (this.contains(e.next())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.closeIterator(c, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends V> c) {
            Iterator<V> e = c.iterator();
            try {
                boolean modified = false;
                while (e.hasNext()) {
                    if (!this.add((V)((Value)e.next()))) continue;
                    modified = true;
                }
                boolean bl = modified;
                return bl;
            }
            finally {
                this.closeIterator(c, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Iterator<V> e = this.iterator();
            try {
                boolean modified = false;
                while (e.hasNext()) {
                    if (c.contains(e.next())) continue;
                    e.remove();
                    modified = true;
                }
                boolean bl = modified;
                return bl;
            }
            finally {
                this.closeIterator(e);
            }
        }

        @Override
        public abstract boolean add(V var1);

        protected abstract V term(Statement var1);

        protected abstract void removeIteration(Iterator<Statement> var1, V var2);

        protected void closeIterator(Iterator<?> iter) {
            AbstractModel.this.closeIterator(((ValueSetIterator)iter).iter);
        }

        private void closeIterator(Collection<?> c, Iterator<?> e) {
            if (c instanceof AbstractModel) {
                ((AbstractModel)c).closeIterator(e);
            } else if (c instanceof ValueSet) {
                ((ValueSet)c).closeIterator(e);
            }
        }

        private final class ValueSetIterator
        implements Iterator<V> {
            private final Iterator<Statement> iter;
            private final Set<V> set = new LinkedHashSet();
            private Statement current;
            private Statement next;

            private ValueSetIterator(Iterator<Statement> iter) {
                this.iter = iter;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.findNext();
                }
                return this.next != null;
            }

            @Override
            public V next() {
                if (this.next == null) {
                    this.next = this.findNext();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                this.current = this.next;
                this.next = null;
                Object value = ValueSet.this.term(this.current);
                this.set.add(value);
                return value;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                ValueSet.this.removeIteration(this.iter, ValueSet.this.term(this.current));
                this.current = null;
            }

            private Statement findNext() {
                while (this.iter.hasNext()) {
                    Statement st = this.iter.next();
                    if (!this.accept(st)) continue;
                    return st;
                }
                return null;
            }

            private boolean accept(Statement st) {
                return !this.set.contains(ValueSet.this.term(st));
            }
        }
    }
}

