/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.GroupByCountFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class MinCountConstraintComponent
extends AbstractConstraintComponent {
    long minCount;

    public MinCountConstraintComponent(long minCount) {
        this.minCount = minCount;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.MIN_COUNT, Values.literal(BigInteger.valueOf(this.minCount)), new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MinCountConstraintComponent;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        LeftOuterJoin leftOuterJoin;
        PlanNode addedByPath;
        PlanNode target;
        if (this.minCount <= 0L) {
            return EmptyNode.getInstance();
        }
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        if (overrideTargetNode != null) {
            target = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
            if (connectionsGroup.hasAddedStatements()) {
                addedByPath = this.getTargetChain().getPath().get().getAnyAdded(connectionsGroup, validationSettings.getDataGraph(), null);
                leftOuterJoin = new LeftOuterJoin(target, addedByPath);
                target = new GroupByCountFilter(leftOuterJoin, count -> count < this.minCount);
            }
        } else {
            target = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, true, null);
            addedByPath = this.getTargetChain().getPath().get().getAnyAdded(connectionsGroup, validationSettings.getDataGraph(), null);
            leftOuterJoin = new LeftOuterJoin(target, addedByPath);
            target = new GroupByCountFilter(leftOuterJoin, count -> count < this.minCount);
        }
        PlanNode relevantTargetsWithPath = new BulkedExternalLeftOuterJoin(Unique.getInstance(new TrimToTarget(target), false), connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), this.getTargetChain().getPath().get().getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true, validationSettings.getDataGraph()));
        relevantTargetsWithPath = connectionsGroup.getCachedNodeFor(relevantTargetsWithPath);
        GroupByCountFilter groupByCount = new GroupByCountFilter(relevantTargetsWithPath, count -> count < this.minCount);
        return Unique.getInstance(new TrimToTarget(groupByCount), false);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, ValidationSettings validationSettings) {
        return EmptyNode.getInstance();
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MinCountConstraintComponent(this.minCount);
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        if (this.minCount <= 0L) {
            return ValidationQuery.Deactivated.getInstance();
        }
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Object query = effectiveTarget.getQuery(false);
        if (this.minCount == 1L) {
            StatementMatcher.Variable<Value> value = StatementMatcher.Variable.VALUE;
            String pathQuery = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of())).orElseThrow(IllegalStateException::new).getFragment();
            query = (String)query + "\nFILTER(NOT EXISTS{\n" + pathQuery + "\n})";
        } else {
            StringBuilder condition = new StringBuilder();
            ArrayList<StatementMatcher.Variable<Value>> valueVariables = new ArrayList<StatementMatcher.Variable<Value>>();
            int i = 0;
            while ((long)i < this.minCount) {
                StatementMatcher.Variable<Value> value = stableRandomVariableProvider.next();
                valueVariables.add(value);
                String pathQuery = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of())).orElseThrow(IllegalStateException::new).getFragment();
                condition.append(pathQuery).append("\n");
                ++i;
            }
            HashSet<CallSite> notEquals = new HashSet<CallSite>();
            for (int i2 = 0; i2 < valueVariables.size(); ++i2) {
                for (int j = 0; j < valueVariables.size(); ++j) {
                    if (i2 == j) continue;
                    if (i2 > j) {
                        notEquals.add((CallSite)((Object)(((StatementMatcher.Variable)valueVariables.get(i2)).asSparqlVariable() + " != " + ((StatementMatcher.Variable)valueVariables.get(j)).asSparqlVariable())));
                        continue;
                    }
                    notEquals.add((CallSite)((Object)(((StatementMatcher.Variable)valueVariables.get(j)).asSparqlVariable() + " != " + ((StatementMatcher.Variable)valueVariables.get(i2)).asSparqlVariable())));
                }
            }
            String innerCondition = String.join((CharSequence)" && ", notEquals);
            query = (String)query + "\nFILTER(NOT EXISTS{\n" + condition.toString().trim() + "\nFILTER(" + innerCondition + ")\n})";
        }
        List<StatementMatcher.Variable<Value>> allTargetVariables = effectiveTarget.getAllTargetVariables();
        return new ValidationQuery(this.getTargetChain().getNamespaces(), (String)query, allTargetVariables, null, scope, this, null, null);
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return ValidationApproach.SPARQL;
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinCountConstraintComponent that = (MinCountConstraintComponent)o;
        return this.minCount == that.minCount;
    }

    public int hashCode() {
        return (int)(this.minCount ^ this.minCount >>> 32) + "MinCountConstraintComponent".hashCode();
    }
}

