/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceModel;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7NamedElement;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertOldElemenetsAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource[] resources = LaunchUtils.getContext(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        final IQ7NamedElement[] elements = TestSuiteUtils.getElements((IResource[])resources, (boolean)false, (boolean)false);
        Job job = new Job("Convert RCPTT elements"){

            protected IStatus run(IProgressMonitor monitor) {
                ModelManager.getModelManager().getIndexManager().disable();
                try {
                    monitor.beginTask("Convert RCPTT elements", elements.length);
                    IQ7NamedElement[] iQ7NamedElementArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block15: {
                            IQ7NamedElement element = iQ7NamedElementArray[n2];
                            if (monitor.isCanceled()) {
                                break;
                            }
                            try {
                                monitor.subTask("Processing " + element.getName());
                                IQ7NamedElement copy = element.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                                try {
                                    try {
                                        IPersistenceModel persistenceModel = copy.getPersistenceModel();
                                        if (!(persistenceModel instanceof PlainTextPersistenceModel)) {
                                            IPersistenceModel newModel = PersistenceManager.getInstance().replaceModelWith(persistenceModel.getResource(), persistenceModel);
                                            ((Q7NamedElement)copy).updatePersistenceModel(newModel);
                                            WriteAccessChecker writeAccessChecker = new WriteAccessChecker();
                                            if (writeAccessChecker.makeResourceWritable(new IQ7Element[]{copy})) {
                                                copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                                            }
                                        }
                                    }
                                    catch (ModelException e) {
                                        Q7UIPlugin.log(e);
                                        copy.discardWorkingCopy();
                                        element.close();
                                        break block15;
                                    }
                                }
                                catch (Throwable throwable) {
                                    copy.discardWorkingCopy();
                                    element.close();
                                    throw throwable;
                                }
                                copy.discardWorkingCopy();
                                element.close();
                            }
                            catch (Throwable e) {
                                Q7UIPlugin.log(e);
                            }
                        }
                        monitor.worked(1);
                        ++n2;
                    }
                }
                finally {
                    ModelManager.getModelManager().getIndexManager().enable();
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        return null;
    }
}

