/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.index.IProjectIndexer;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.IndexRequest;
import org.eclipse.rcptt.internal.core.model.index.ReadWriteMonitor;

public class NamedElementsRequest
extends IndexRequest {
    private final IQ7Project project;
    private final List<IQ7NamedElement> elements;
    private boolean clearOther = false;

    public NamedElementsRequest(IProjectIndexer indexer, IQ7Project project, List<IQ7NamedElement> elements, boolean clearOther) {
        super(indexer);
        this.project = project;
        this.elements = elements;
        this.clearOther = clearOther;
    }

    @Override
    protected String getName() {
        return this.project.getName();
    }

    @Override
    protected void run() throws CoreException, IOException {
        final Index index = this.getIndexer().getProjectIndex(this.project);
        if (index == null) {
            RcpttPlugin.log("Index are null for:" + String.valueOf(this.elements), null);
            return;
        }
        List<Object> changes = this.checkChanges(index, this.elements, this.clearOther);
        if (changes.isEmpty()) {
            return;
        }
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            try {
                ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2 + 1);
                Iterator<Object> i = changes.iterator();
                while (!this.isCancelled && i.hasNext()) {
                    final Object change = i.next();
                    if (change instanceof String) {
                        index.remove((String)change);
                        continue;
                    }
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            NamedElementsRequest.this.getIndexer().indexNamedElement(index, (IQ7NamedElement)change);
                        }
                    });
                }
                executor.shutdown();
                while (!executor.isTerminated()) {
                    Thread.sleep(50L);
                }
            }
            catch (Throwable t) {
                RcpttPlugin.log(t);
                try {
                    try {
                        index.save();
                    }
                    catch (IOException e) {
                        RcpttPlugin.log("error saving index", e);
                        imon.exitWrite();
                    }
                }
                finally {
                    imon.exitWrite();
                }
            }
        }
        finally {
            block25: {
                try {
                    try {
                        index.save();
                    }
                    catch (IOException e) {
                        RcpttPlugin.log("error saving index", e);
                        imon.exitWrite();
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    imon.exitWrite();
                    throw throwable;
                }
                imon.exitWrite();
            }
        }
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.project.getProject().getName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedElementsRequest other = (NamedElementsRequest)obj;
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }
}

