/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.zephyr;

import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.eclipse.rcptt.internal.zephyr.ZephyrPlugin;

public final class ZephyrRestClient {
    private static final String URL_GET_PROJECTS = "%s/rest/api/2/project?expand";
    private static final String URL_GET_USERS = "%s/rest/api/2/user?username=%s";
    private static final String URL_GET_ISSUETYPES = "%s/rest/api/2/issuetype";
    private static final String TEST_ISSSUETYPE_NAME = "Test";
    private static final long ISSUE_TYPE_ID = 10100L;
    private CloseableHttpClient httpclient;
    private HttpClientContext context;
    private final String url;
    private final String userName;
    private final String password;

    public ZephyrRestClient(String url, String userName, String password) {
        this.url = StringUtils.removeEnd((String)url, (String)"/");
        this.userName = userName;
        this.password = password;
        this.createClientContext(this.url, this.userName, this.password);
        this.createHttpClient();
    }

    public void destroy() {
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
            }
            catch (IOException e) {
                ZephyrPlugin.log(e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean validateConnection() {
        boolean status;
        block17: {
            status = false;
            String constructedURL = String.format(URL_GET_PROJECTS, this.getUrl());
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (CloseableHttpResponse response = this.get(constructedURL);){
                    block18: {
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode < 200) break block18;
                        if (statusCode >= 300) break;
                        HttpEntity entity = response.getEntity();
                        String string = null;
                        try {
                            string = EntityUtils.toString((HttpEntity)entity);
                            if (string.startsWith("[") && string.endsWith("]")) {
                                return true;
                            }
                            break block17;
                        }
                        catch (IOException e) {
                            ZephyrPlugin.log(e);
                            break block17;
                        }
                    }
                    {
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                ZephyrPlugin.log(e);
                return false;
            }
        }
        return status;
    }

    public boolean validateCredentials() {
        boolean status = true;
        String constructedURL = String.format(URL_GET_USERS, this.getUrl(), this.getUserName());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CloseableHttpResponse response = this.get(constructedURL);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 401) {
                    status = false;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get " + constructedURL, e);
        }
        return status;
    }

    /*
     * Unable to fully structure code
     */
    public long findZephyrTypeId() {
        block20: {
            status = 10100L;
            url = String.format("%s/rest/api/2/issuetype", new Object[]{this.getUrl()});
            headers = new Header[]{new BasicHeader("Content-Type", "application/json"), new BasicHeader("Accept-Encoding", "gzip, deflate, sdch")};
            try {
                var5_4 = null;
                var6_7 = null;
                try {
                    response = this.get(url, headers);
                    try {
                        statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode >= 200 && statusCode < 300) {
                            entity = response.getEntity();
                            string = null;
                            string = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                            jArr = new JsonParser().parse(string).getAsJsonArray();
                            jArr.add(string);
                            i = 0;
                            while (i < jArr.size()) {
                                jObj = jArr.get(i).getAsJsonObject();
                                if (!jObj.get("name").getAsString().trim().equals("Test")) ** break block19
                                return jObj.get("id").getAsLong();
                            }
                            break block20;
                            {
                                try {
                                    ++i;
                                    continue;
                                }
                                catch (IOException e) {
                                    ZephyrPlugin.log(String.format("Bad response entity upon receipt of zephyr type id <%s>", new Object[]{url}), e);
                                }
                                break block20;
                                break;
                            }
                        }
                        if (statusCode == 401 || statusCode == 404) {
                            return status;
                        }
                        ZephyrPlugin.log(String.format("Unexpected response status <%s> upon receipt of zephyr type id <%s>", new Object[]{statusCode, url}));
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Throwable var6_8) {
                    if (var5_4 == null) {
                        var5_4 = var6_8;
                    } else if (var5_4 != var6_8) {
                        var5_4.addSuppressed(var6_8);
                    }
                    throw var5_4;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get " + url, e);
            }
        }
        return status;
    }

    private HttpClientContext createClientContext(String hostAddressWithProtocol, String userName, String password) {
        try {
            URL url = new URL(hostAddressWithProtocol);
            HttpHost targetHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
            this.context = HttpClientContext.create();
            this.context.setCredentialsProvider((CredentialsProvider)credsProvider);
            this.context.setAuthCache((AuthCache)authCache);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return this.context;
    }

    private void createHttpClient() {
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            this.httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public CloseableHttpResponse get(String url) {
        return this.get(new HttpGet(url));
    }

    public CloseableHttpResponse get(String url, Header[] headers) {
        HttpGet httpGet = new HttpGet(url);
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            httpGet.addHeader(header);
            ++n2;
        }
        return this.get(httpGet);
    }

    private CloseableHttpResponse get(HttpGet httpGet) {
        try {
            return this.httpclient.execute((HttpUriRequest)httpGet, (HttpContext)this.context);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public CloseableHttpResponse put(String url, Header[] headers, HttpEntity entity) {
        HttpPut httpPut = new HttpPut(url);
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            httpPut.addHeader(header);
            ++n2;
        }
        httpPut.setEntity(entity);
        return this.put(httpPut);
    }

    private CloseableHttpResponse put(HttpPut httpPut) {
        try {
            return this.httpclient.execute((HttpUriRequest)httpPut, (HttpContext)this.context);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

