/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util.swt;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Point;

public class StringLines {
    private final String[] lines;
    private static final Pattern endings = Pattern.compile(".*(\r\n|\r|\n)");

    public StringLines(String text) {
        this.lines = StringLines.linesWithEndings(text);
    }

    private static String[] linesWithEndings(String text) {
        Matcher m = endings.matcher(text);
        ArrayList<String> lines = new ArrayList<String>();
        int last = 0;
        while (m.find()) {
            String line = m.group();
            if (!line.isEmpty()) {
                lines.add(line);
            }
            last = m.end();
        }
        lines.add(text.substring(last));
        return lines.toArray(new String[lines.size()]);
    }

    private int lineWithoutEndingLength(int lineIndex) {
        String line = this.lines[lineIndex];
        int len = line.length();
        if (line.endsWith("\r\n")) {
            return len - 2;
        }
        if (line.endsWith("\r") || line.endsWith("\n")) {
            return len - 1;
        }
        return len;
    }

    public String calcLineColumn(int istart) {
        int pos = 0;
        int j = 0;
        while (j < this.lines.length) {
            boolean lastLine;
            assert (pos <= istart);
            boolean bl = lastLine = j == this.lines.length - 1;
            if (istart < pos + this.lines[j].length() || lastLine) {
                return String.valueOf(Integer.toString(j + 1)) + ":" + Integer.toString(istart - pos + 1);
            }
            pos += this.lines[j].length();
            ++j;
        }
        throw new AssertionError((Object)"should not be here");
    }

    public int calcOffset(String coords) {
        try {
            return this.calcOffset(StringLines.parseLineColumnCoords(coords));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int calcOffset(Point coords) {
        int column;
        int line;
        block5: {
            line = coords.x;
            column = coords.y;
            if (line >= 0 && line < this.lines.length && column >= 0 && column <= this.lineWithoutEndingLength(line)) break block5;
            return -1;
        }
        try {
            int offset = 0;
            if (line > 0 && line < this.lines.length) {
                int ppos = 0;
                int j = 0;
                while (j < line) {
                    ppos += this.lines[j].length();
                    ++j;
                }
                offset += ppos;
            }
            return offset + column;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static Point parseLineColumnCoords(String pos) throws Exception {
        try {
            String[] split = pos.split(":");
            if (split.length == 2) {
                int line = Integer.parseInt(split[0]) - 1;
                int column = Integer.parseInt(split[1]) - 1;
                return new Point(line, column);
            }
        }
        catch (Exception exception) {}
        throw new Exception("Cannot parse text location value");
    }

    public static int parseSingleLineCoord(String pos) {
        try {
            return Integer.parseInt(pos) - 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

