/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.ClausalCardinalitiesDecorator;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;
import org.sat4j.tools.encoding.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClausalConstraintsDecorator
extends ClausalCardinalitiesDecorator<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private final IPBSolver solver;

    public ClausalConstraintsDecorator(IPBSolver solver, EncodingStrategyAdapter encodingAd) {
        super((ISolver)solver, encodingAd);
        this.solver = solver;
    }

    public ClausalConstraintsDecorator(IPBSolver solver) {
        super((ISolver)solver, (EncodingStrategyAdapter)new Policy());
        this.solver = solver;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(coeffs)) {
            if (moreThan) {
                return super.addAtLeast(lits, d.intValue());
            }
            return super.addAtMost(lits, d.intValue());
        }
        return this.solver.addPseudoBoolean(lits, coeffs, moreThan, d);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        this.solver.setObjectiveFunction(obj);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.solver.getObjectiveFunction();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(coeffs)) {
            return super.addAtMost(literals, degree);
        }
        return this.solver.addAtMost(literals, coeffs, degree);
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(coeffs)) {
            return super.addAtMost(literals, degree.intValue());
        }
        return this.solver.addAtMost(literals, coeffs, degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(coeffs)) {
            return super.addAtLeast(literals, degree);
        }
        return this.solver.addAtLeast(literals, coeffs, degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(coeffs)) {
            return super.addAtLeast(literals, degree.intValue());
        }
        return this.solver.addAtLeast(literals, coeffs, degree);
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(coeffs)) {
            return super.addExactly(literals, weight);
        }
        return this.solver.addExactly(literals, coeffs, weight);
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(coeffs)) {
            return super.addExactly(literals, weight.intValue());
        }
        return this.solver.addExactly(literals, coeffs, weight);
    }

    public static boolean isCardinality(IVecInt coeffs) {
        boolean result = true;
        int i = 0;
        while (result && i < coeffs.size()) {
            result = coeffs.get(i) == 1;
            ++i;
        }
        return result;
    }

    public static boolean isCardinality(IVec<BigInteger> coeffs) {
        boolean result = true;
        int i = 0;
        while (result && i < coeffs.size()) {
            result = coeffs.get(i) == BigInteger.ONE;
            ++i;
        }
        return result;
    }
}

