/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.internal.registration.IRegistryWriter;
import org.eclipse.urischeme.internal.registration.RegistryWriter;
import org.eclipse.urischeme.internal.registration.SchemeInformation;

public class RegistrationWindows
implements IOperatingSystemRegistration {
    IRegistryWriter registryWriter;

    public RegistrationWindows() {
        this(new RegistryWriter());
    }

    public RegistrationWindows(IRegistryWriter registryWriter) {
        this.registryWriter = registryWriter;
    }

    @Override
    public void handleSchemes(Collection<IScheme> toAdd, Collection<IScheme> toRemove) throws Exception {
        for (IScheme scheme : toAdd) {
            this.registryWriter.addScheme(scheme.getName());
        }
        for (IScheme scheme : toRemove) {
            this.registryWriter.removeScheme(scheme.getName());
        }
    }

    @Override
    public List<ISchemeInformation> getSchemesInformation(Collection<IScheme> schemes) throws Exception {
        String launcher = this.getEclipseLauncher();
        ArrayList<ISchemeInformation> schemeInformations = new ArrayList<ISchemeInformation>();
        for (IScheme scheme : schemes) {
            SchemeInformation schemeInfo = new SchemeInformation(scheme.getName(), scheme.getDescription());
            String path = this.registryWriter.getRegisteredHandlerPath(schemeInfo.getName());
            if (path == null) {
                path = "";
            }
            schemeInfo.setHandled(path.equals(launcher));
            schemeInfo.setHandlerLocation(path);
            schemeInformations.add(schemeInfo);
        }
        return schemeInformations;
    }

    @Override
    public String getEclipseLauncher() {
        return System.getProperty("eclipse.launcher");
    }
}

