/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.ecl.impl.AbstractActionService;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.GetItems;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class GetItemsService
extends AbstractActionService {
    @Override
    protected Object exec(Command command) throws CoreException {
        GetItems cmd = (GetItems)command;
        final ControlHandler handler = cmd.getControl();
        Element element = TeslaBridge.find(handler, this.getContext());
        final Widget widget = ((SWTUIElement)((SWTUIProcessor)TeslaBridge.getClient().getProcessor(SWTUIProcessor.class)).getMapper().get((Element)element)).widget;
        if (!(widget instanceof Tree || widget instanceof TreeItem || widget instanceof Table)) {
            return TeslaImplPlugin.err("'get-items' can be used only on table or tree or tree item");
        }
        final ArrayList items = new ArrayList();
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                GetItemsService.getItems(items, widget, handler);
            }
        });
        for (ControlHandler h : items) {
            this.getContext().getOutput().write((Object)h);
        }
        return null;
    }

    private static void getItems(List<ControlHandler> result, Widget widget, ControlHandler parent) {
        block9: {
            TreeItem[] roots;
            HashMap<String, Integer> counters;
            block8: {
                counters = new HashMap<String, Integer>();
                if (!(widget instanceof Table)) break block8;
                Table table = (Table)widget;
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem i = tableItemArray[n2];
                    ControlHandler handler = TeslaFactory.eINSTANCE.createControlHandler();
                    handler.setKind(ElementKind.Item);
                    handler.setParent(parent);
                    if (!counters.containsKey(i.getText())) {
                        counters.put(i.getText(), 1);
                        handler.setPath(GetItemsService.escapePathFragment(i.getText()));
                    } else {
                        int index = (Integer)counters.get(i.getText());
                        counters.put(i.getText(), index + 1);
                        handler.setPath(String.valueOf(GetItemsService.escapePathFragment(i.getText())) + "%" + index + "%");
                    }
                    result.add(handler);
                    ++n2;
                }
                break block9;
            }
            if (!(widget instanceof Tree) && !(widget instanceof TreeItem)) break block9;
            if (widget instanceof TreeItem && !((TreeItem)widget).getExpanded()) {
                return;
            }
            TreeItem[] treeItemArray = roots = widget instanceof Tree ? ((Tree)widget).getItems() : ((TreeItem)widget).getItems();
            if (widget instanceof TreeItem) {
                parent = parent.getParent();
            }
            ArrayList<TreeItem> expanded = new ArrayList<TreeItem>();
            GetItemsService.listExpanded(expanded, roots);
            for (TreeItem i : expanded) {
                ControlHandler handler = TeslaFactory.eINSTANCE.createControlHandler();
                handler.setKind(ElementKind.Item);
                handler.setParent(parent);
                String path = GetItemsService.makeTreeItemPath(i);
                if (!counters.containsKey(path)) {
                    counters.put(path, 1);
                    handler.setPath(path);
                } else {
                    int index = (Integer)counters.get(path);
                    counters.put(path, index + 1);
                    handler.setPath(String.valueOf(path) + "%" + index + "%");
                }
                result.add(handler);
            }
        }
    }

    private static void listExpanded(List<TreeItem> result, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            result.add(i);
            if (i.getExpanded()) {
                GetItemsService.listExpanded(result, i.getItems());
            }
            ++n2;
        }
    }

    private static String makeTreeItemPath(TreeItem item) {
        StringBuilder b = new StringBuilder();
        while (item != null) {
            if (b.length() > 0) {
                b.insert(0, '/');
            }
            b.insert(0, GetItemsService.escapePathFragment(item.getText()));
            item = item.getParentItem();
        }
        return b.toString();
    }

    private static String escapePathFragment(String path) {
        path = SWTUIPlayer.toSelectionItem((String)path);
        path = path.replaceAll("/", "\\\\/");
        return path;
    }
}

