/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runtime.ui.rap;

import java.io.IOException;
import java.net.InetAddress;
import org.eclipse.rcptt.ecl.client.tcp.EclTcpSession;
import org.eclipse.rcptt.ecl.debug.runtime.SuspendListener;
import org.eclipse.rcptt.ecl.debug.runtime.SuspendManager;
import org.eclipse.rcptt.ecl.server.tcp.EclTcpServerManager;
import org.eclipse.rcptt.internal.runtime.ui.rap.Activator;
import org.eclipse.rcptt.tesla.core.server.TeslaServerManager;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.util.NetworkUtils;

public enum Q7ServerStarter {
    INSTANCE;

    private static final int PORT_RANGE_START = 7001;
    private static final int PORT_RANGE_END = 10000;
    private static final String VAR_TESLA = "teslaPort";
    private static final String VAR_ECL = "eclPort";
    private int ecl = -1;
    private int tesla = -1;

    public boolean isActive() {
        return this.ecl > 0 && this.tesla > 0;
    }

    public int getEclPort() {
        return this.ecl;
    }

    public int getTeslaPort() {
        return this.tesla;
    }

    public void start() {
        NetworkUtils.initTimeouts();
        if (this.ecl < 0) {
            this.ecl = Q7ServerStarter.createEclServer(7001, 10000);
            Activator.info("ECL server started on port %s", this.ecl);
            this.testLocalEclServer();
        }
        if (this.tesla < 0) {
            this.tesla = Q7ServerStarter.createTeslaServer(7001, 10000);
            Activator.info("Tesla server started on port %s", this.tesla);
        }
        Q7ServerStarter.unfreezeOnSuspend();
    }

    private void testLocalEclServer() {
        try {
            new EclTcpSession(InetAddress.getByName("localhost"), this.ecl);
            Activator.info("Verified that local ECL server is working", new Object[0]);
        }
        catch (IOException e) {
            Activator.err(e, "Error testing a local ECL server. Something is blocking connection", new Object[0]);
        }
    }

    private static int createEclServer(int from, int to) {
        int port = Q7ServerStarter.getProperty(VAR_ECL);
        if (port > 0) {
            try {
                Activator.info("Starting ECL server on port %s", port);
                EclTcpServerManager.Instance.startServer(port);
                return port;
            }
            catch (Exception e) {
                Activator.log("Default ECL port '" + port + "' already in use", e);
            }
        }
        port = from;
        while (port < to) {
            try {
                Activator.info("Trying to start ECL server on port %s", port);
                EclTcpServerManager.Instance.startServer(port);
                return port;
            }
            catch (Exception exception) {
                ++port;
            }
        }
        throw new IllegalStateException("No one available port found for ECL TCP server within range [" + from + ", " + to + "]");
    }

    private static int createTeslaServer(int from, int to) {
        int port = Q7ServerStarter.getProperty(VAR_TESLA);
        if (port > 0) {
            try {
                Activator.info("Starting Tesla server on port %s", port);
                TeslaServerManager.startServer((int)port);
                return port;
            }
            catch (Exception e) {
                Activator.log("Default Tesla port '" + port + "' already in use", e);
            }
        }
        port = from;
        while (port < to) {
            try {
                Activator.info("Trying to start Tesla server on port %s", port);
                TeslaServerManager.startServer((int)port);
                return port;
            }
            catch (Exception exception) {
                ++port;
            }
        }
        throw new IllegalStateException("No one available port found for Tesla Network server within range [" + from + ", " + to + "]");
    }

    private static void unfreezeOnSuspend() {
        SuspendManager.INSTANCE.addListener(new SuspendListener(){

            public void suspend() {
                TeslaEventManager.getManager().setUnfreeze(true);
            }

            public void resume() {
                TeslaEventManager.getManager().setUnfreeze(false);
            }
        });
    }

    private static int getProperty(String var) {
        String port = Activator.getDefault().getBundle().getBundleContext().getProperty(var);
        if (port != null && !port.isEmpty()) {
            try {
                return Integer.valueOf(port);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }
}

