/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.rap.model.UploadFile;
import org.eclipse.rcptt.tesla.swt.dialogs.SWTDialogManager;
import org.eclipse.rcptt.util.Base64;
import org.eclipse.rcptt.util.FileSystemResolver;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.util.PrefixScheme;
import org.eclipse.rcptt.util.StringUtils;

public class UploadFileService
implements ICommandService {
    private FileSystemResolver resolver = UploadFileService.makeResolver();

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        UploadFile cmd = (UploadFile)command;
        try {
            String path = null;
            path = !StringUtils.isEmpty((String)cmd.getBase64()) ? this.saveFileFormContext(cmd.getBase64()) : this.getPath(cmd.getFile());
            File file = this.getFile(path);
            SWTDialogManager.addFileDialogInfo((String)file.getAbsolutePath());
        }
        catch (CoreException ex) {
            return TeslaImplPlugin.err(ex.getMessage(), ex);
        }
        return Status.OK_STATUS;
    }

    private String saveFileFormContext(String base64) {
        try {
            File file = new File(UploadFileService.createTempDirectory(), "tmp.file");
            file.createNewFile();
            ByteArrayInputStream input = new ByteArrayInputStream(Base64.decode((String)base64));
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                FileUtil.copy((InputStream)input, (File)file, (boolean)true);
            }
            finally {
                outputStream.close();
            }
            return file.getAbsolutePath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static File createTempDirectory() throws IOException {
        File result = File.createTempFile("fileupload_", "");
        result.delete();
        if (!result.mkdir()) {
            throw new IOException("Unable to create temp directory: " + result.getAbsolutePath());
        }
        result.deleteOnExit();
        return result;
    }

    private String getPath(String path) throws CoreException {
        if (StringUtils.isEmpty((String)path)) {
            throw new CoreException(TeslaImplPlugin.error("The path to file is empty"));
        }
        try {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path, true);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new CoreException(TeslaImplPlugin.error("Invalid path to file."));
        }
        path = this.resolver.resolve(path);
        if (StringUtils.isEmpty((String)path)) {
            throw new CoreException(TeslaImplPlugin.error("The path is not resolved."));
        }
        return path;
    }

    private File getFile(String path) throws CoreException {
        File file = new File(path);
        if (!file.exists()) {
            throw new CoreException(TeslaImplPlugin.error("The file does not exist."));
        }
        if (!file.isFile()) {
            throw new CoreException(TeslaImplPlugin.error("It is not a file path."));
        }
        return file;
    }

    private static FileSystemResolver makeResolver() {
        File file;
        URL url;
        FileSystemResolver resolver = new FileSystemResolver();
        Location location = Platform.getInstanceLocation();
        if (location != null && (url = location.getURL()) != null) {
            try {
                file = new File(url.toURI());
                resolver.register((FileSystemResolver.Scheme)new PrefixScheme("workspace://", file.toString()));
            }
            catch (Exception exception) {}
        }
        if ((location = Platform.getInstallLocation()) != null && (url = location.getURL()) != null) {
            try {
                file = new File(url.toURI());
                resolver.register((FileSystemResolver.Scheme)new PrefixScheme("aut://", file.toString()));
            }
            catch (Exception exception) {}
        }
        resolver.register((FileSystemResolver.Scheme)new PrefixScheme("file://", null));
        resolver.register((FileSystemResolver.Scheme)new PrefixScheme("home://", new File(System.getProperty("user.home")).getAbsolutePath()));
        return resolver;
    }
}

