/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.aspects.jface.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.rcptt.tesla.recording.aspects.jface.text.IJFaceTextEventListener;
import org.eclipse.rcptt.util.WeakMap;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class JFaceTextEventManager {
    private static WeakMap<StyledText, TextViewer> viewersMap = new WeakMap();
    private static WeakMap<Canvas, IVerticalRuler> rulersMap = new WeakMap();
    private static WeakMap<IVerticalRuler, ITextViewer> rulersViewerMap = new WeakMap();
    private static Set<IJFaceTextEventListener> listeners = new HashSet<IJFaceTextEventListener>();

    private JFaceTextEventManager() {
    }

    public static void addListener(IJFaceTextEventListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(IJFaceTextEventListener listener) {
        listeners.remove(listener);
    }

    public static void showContentAssist(Object control, boolean autoActivation) {
        for (IJFaceTextEventListener listener : listeners) {
            listener.showContentAssist(control, autoActivation);
        }
    }

    public static void activateInfomationWindow(Widget widget, Rectangle subjectArea) {
        for (IJFaceTextEventListener listener : listeners) {
            listener.activateInfomationWindow(widget, subjectArea);
        }
    }

    public static void mapViewer(StyledText text, TextViewer viewer) {
        viewersMap.put((Object)text, (Object)viewer);
    }

    public static TextViewer getViewer(StyledText widget) {
        return (TextViewer)viewersMap.get((Object)widget);
    }

    public static void mapRuler(IVerticalRuler ruler, Control widget, ITextViewer viewer) {
        if (widget instanceof Canvas) {
            rulersMap.put((Object)((Canvas)widget), (Object)ruler);
            rulersViewerMap.put((Object)ruler, (Object)viewer);
        }
    }

    public static List<IVerticalRuler> getRulers() {
        return new ArrayList<IVerticalRuler>(rulersMap.values());
    }
}

