/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.builder;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.core.workspace.ProjectUtil;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class MigrateProjectsJob
extends Job {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private final IContainer resource;
    private final IResourceVisitor resourceVisitor = new IResourceVisitor(){

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IProject) {
                MigrateProjectsJob.this.migrate((IProject)resource);
                return false;
            }
            return true;
        }
    };

    public MigrateProjectsJob(IContainer resource) {
        super("RCPTT: Migrate Q7 projects");
        this.resource = resource;
        this.setRule((ISchedulingRule)ROOT);
    }

    void migrate(IProject iProject) {
        try {
            if (!iProject.isAccessible()) {
                return;
            }
            if (!iProject.hasNature("com.xored.q7.core.q7nature")) {
                return;
            }
            if (iProject.hasNature("org.eclipse.rcptt.core.rcpttnature")) {
                return;
            }
            iProject.refreshLocal(1, null);
            if (!iProject.hasNature("com.xored.q7.core.q7nature")) {
                return;
            }
            this.migrateProperties(iProject);
            this.migrateNatures(iProject);
        }
        catch (Throwable e) {
            RcpttPlugin.log((Throwable)new RuntimeException("Migration of " + iProject.getName() + " failed", e));
        }
    }

    private void migrateNatures(IProject iProject) throws CoreException {
        IProjectDescription description = iProject.getDescription();
        ArrayList natures = Lists.newArrayList((Object[])description.getNatureIds());
        if (!natures.contains("org.eclipse.rcptt.core.rcpttnature")) {
            natures.add("org.eclipse.rcptt.core.rcpttnature");
        }
        description.setNatureIds((String[])Iterables.toArray((Iterable)natures, String.class));
        iProject.setDescription(description, null);
    }

    void migrateProperties(IProject project) throws CoreException {
        IFile q7Metadata = project.getFile((IPath)new Path("q7.properties"));
        if (!q7Metadata.exists()) {
            return;
        }
        IFile rcpttMetadata = project.getFile((IPath)new Path("rcptt.properties"));
        if (!rcpttMetadata.exists()) {
            q7Metadata.copy(rcpttMetadata.getFullPath(), true, null);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.resource.isAccessible()) {
                return Status.OK_STATUS;
            }
            this.resource.accept(this.resourceVisitor);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public IStatus runSync() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    MigrateProjectsJob.this.run(monitor);
                }
            }, null);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.equals(ProjectUtil.MIGRATION_FAMILY)) {
            return true;
        }
        return super.belongsTo(family);
    }
}

