/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.multiaut.ui;

import java.util.List;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.multiaut.LaunchStoreEntry;
import org.eclipse.rcptt.launching.multiaut.ui.MultiAutUIPlugin;

public class LaunchUIEntry {
    public final IQ7NamedElement element;
    public Aut aut;
    public boolean restart;
    protected LaunchStoreEntry sourceEntry;

    private LaunchUIEntry(IQ7NamedElement element, Aut aut, boolean restart, LaunchStoreEntry sourceEntry) {
        this.element = element;
        this.aut = aut;
        this.restart = restart;
        this.sourceEntry = sourceEntry;
    }

    public static LaunchUIEntry fromStoreEntry(LaunchStoreEntry entry) {
        if (entry.testId == null) {
            MultiAutUIPlugin.logWarn("Entry with null id stored in multi aut launch config, ignoring", new Object[0]);
            return null;
        }
        IQ7NamedElement element = Q7SearchCore.findById((String)entry.testId);
        Aut aut = AutManager.INSTANCE.getByName(entry.autName);
        if (element == null) {
            return new LaunchUIEntry(null, aut, entry.restart, entry);
        }
        return new LaunchUIEntry(element, aut, entry.restart, entry);
    }

    public static LaunchUIEntry fromNamedElement(IQ7NamedElement element) {
        return new LaunchUIEntry(element, LaunchUIEntry.defaultAut(), false, null);
    }

    private static Aut defaultAut() {
        List auts = AutManager.INSTANCE.getAuts();
        return auts.size() == 0 ? null : (Aut)auts.get(0);
    }

    public LaunchStoreEntry toStoreEntry() {
        try {
            return new LaunchStoreEntry(this.element.getID(), this.aut.getName(), this.restart);
        }
        catch (ModelException e) {
            MultiAutUIPlugin.logErr(e, "Model exception while getting id from element '%s'", this.element.getName());
            return null;
        }
    }

    public String getTestName() {
        return this.element == null ? "Unresolved" : this.element.getName();
    }

    public String getAutName() {
        if (this.aut != null) {
            return this.aut.getName();
        }
        if (this.sourceEntry.autName == null) {
            return "";
        }
        return this.sourceEntry.autName;
    }
}

