/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.bc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRingCollection;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.bc.i18n.BcMessages;

final class BcResidentSecretKey {
    private final InputStream residence;
    private final String owner;

    BcResidentSecretKey(InputStream residence, String owner) {
        this.residence = residence;
        this.owner = owner;
    }

    PGPSecretKey get() throws LicensingException {
        return this.stream(this.rings()).map(PGPSecretKeyRing::getSecretKeys).map(this::find).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new LicensingException(BcMessages.getString("BcStreamCodec_encode_error_no_key")));
    }

    private Iterator<PGPSecretKeyRing> rings() throws LicensingException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream decoder = PGPUtil.getDecoderStream((InputStream)this.residence);){
                return new JcaPGPSecretKeyRingCollection(decoder).getKeyRings();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPException e) {
            throw new LicensingException(BcMessages.getString("BcStreamCodec_encode_error_no_key"), e);
        }
    }

    private Optional<PGPSecretKey> find(Iterator<PGPSecretKey> keys) {
        return this.stream(keys).filter(PGPSecretKey::isSigningKey).filter(this::signedByOwner).findFirst();
    }

    private boolean signedByOwner(PGPSecretKey key) {
        return this.stream(key.getUserIDs()).anyMatch(signer -> Objects.equals(signer, this.owner));
    }

    private <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }
}

