/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.agreements.core;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.passage.lic.agreements.AgreementDescriptor;
import org.eclipse.passage.lic.agreements.AgreementGroupDescriptor;
import org.eclipse.passage.lic.agreements.model.api.Agreement;
import org.eclipse.passage.lic.agreements.model.api.AgreementGroup;
import org.eclipse.passage.loc.internal.agreements.core.AgreementDomainRegistry;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;

public class AgreementsDomainRegistryTracker
extends DomainContentAdapter<AgreementGroupDescriptor, AgreementDomainRegistry> {
    public AgreementsDomainRegistryTracker(AgreementDomainRegistry registry) {
        super((EditingDomainRegistry)registry);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof AgreementGroup) {
            AgreementGroup group = (AgreementGroup)notifier;
            switch (notification.getFeatureID(AgreementGroup.class)) {
                case 0: {
                    this.processAgreementGroupIdentifier(group, notification);
                    break;
                }
                case 3: {
                    this.processAgreementGroupContent(notification);
                    break;
                }
            }
        } else if (notifier instanceof Agreement) {
            Agreement agreement = (Agreement)notifier;
            switch (notification.getFeatureID(Agreement.class)) {
                case 0: {
                    this.processAgreementIdentifier(agreement, notification);
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void processAgreementGroupIdentifier(AgreementGroup group, Notification notification) {
        String old = notification.getOldStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (old != null) {
                    ((AgreementDomainRegistry)this.registry).unregisterAgreementGroup(old);
                }
                if (notification.getNewStringValue() == null) break;
                ((AgreementDomainRegistry)this.registry).registerAgreementGroup((AgreementGroupDescriptor)group);
                break;
            }
        }
    }

    protected void processAgreementGroupContent(Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                Agreement agreement;
                String identifier;
                if (!(newValue instanceof Agreement) || (identifier = (agreement = (Agreement)newValue).getIdentifier()) == null) break;
                ((AgreementDomainRegistry)this.registry).registerAgreement((AgreementDescriptor)agreement);
                break;
            }
            case 4: {
                String identifier;
                if (!(oldValue instanceof Agreement) || (identifier = ((Agreement)oldValue).getIdentifier()) == null) break;
                ((AgreementDomainRegistry)this.registry).unregisterAgreement(identifier);
                break;
            }
        }
    }

    protected void processAgreementIdentifier(Agreement agreement, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((AgreementDomainRegistry)this.registry).unregisterAgreement(oldValue);
                }
                if (newValue == null) break;
                ((AgreementDomainRegistry)this.registry).registerAgreement((AgreementDescriptor)agreement);
                break;
            }
        }
    }
}

