/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.internal.jetty.JettyException;
import org.eclipse.passage.lic.internal.jetty.JettyServer;
import org.eclipse.passage.lic.internal.jetty.interaction.Command;
import org.eclipse.passage.lic.internal.jetty.interaction.LicenseProtection;
import org.eclipse.passage.lic.internal.jetty.interaction.Scope;
import org.eclipse.passage.lic.internal.net.connect.Port;

final class ServerHandles
extends Command {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final JettyServer server;
    private final Port port;
    private final LicenseProtection license = new LicenseProtection();

    ServerHandles(JettyServer server, String name) {
        super(new Scope.Of(name), new String[]{"start", "stop", "restart", "state"});
        this.server = server;
        this.port = new Port(8090);
    }

    public void start() {
        if (!this.license.check()) {
            return;
        }
        try {
            this.server.launch(this.port);
        }
        catch (JettyException e) {
            this.log.error("failed to launch Jetty server", (Throwable)e);
        }
    }

    public void stop() {
        this.license.release();
        try {
            this.server.terminate();
        }
        catch (JettyException e) {
            this.log.error("failed to terminate Jetty server", (Throwable)e);
        }
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void state() {
        try {
            System.out.println(this.server.state());
        }
        catch (JettyException e) {
            this.log.error("failed to report state of Jetty server", (Throwable)e);
        }
    }
}

