/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.PassageAction;
import org.eclipse.passage.lic.internal.base.NamedData;
import org.eclipse.passage.lic.internal.base.ProductIdentifier;
import org.eclipse.passage.lic.internal.base.ProductVersion;
import org.eclipse.passage.lic.internal.hc.i18n.AccessMessages;
import org.eclipse.passage.lic.internal.hc.remote.QueryParameters;
import org.eclipse.passage.lic.internal.net.EncodingAlgorithm;
import org.eclipse.passage.lic.internal.net.LicenseUser;
import org.eclipse.passage.lic.internal.net.LicensingAction;
import org.eclipse.passage.lic.internal.net.ServerAuthenticationExpression;
import org.eclipse.passage.lic.internal.net.ServerAuthenticationType;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess;

public abstract class RequestParameters
implements QueryParameters {
    private final LicensedProduct product;
    private final FloatingLicenseAccess access;
    private final String hash;

    protected RequestParameters(LicensedProduct product, FloatingLicenseAccess access, String hash) {
        this.product = product;
        this.access = access;
        this.hash = hash;
    }

    @Override
    public final String query() throws LicensingException {
        StringBuilder params = new StringBuilder();
        this.parameters().stream().map(NamedData.Writable::new).forEach(writable -> writable.write(params, "=", "&"));
        return String.valueOf('?') + params.toString();
    }

    private List<NamedData> parameters() throws LicensingException {
        return Arrays.asList(this.generalParameters(), this.actionParameters()).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<NamedData> generalParameters() throws LicensingException {
        return Arrays.asList(new ProductIdentifier(this.encode(this.product.identifier())), new ProductVersion(this.encode(this.product.version())), new LicensingAction(this.action()), new LicenseUser(this.access.getUser()), new LicenseUser(this.access.getUser()), new EncodingAlgorithm(this.hash), new ServerAuthenticationType(this.access.getServer().getAuthentication().getType()), new ServerAuthenticationExpression(this.encode(this.access.getServer().getAuthentication().getExpression())));
    }

    protected String encode(String value) throws LicensingException {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LicensingException(AccessMessages.RequestParameters_encoding_failed, (Throwable)e);
        }
    }

    protected abstract PassageAction action() throws LicensingException;

    protected abstract List<NamedData> actionParameters() throws LicensingException;
}

