/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.emf.common.util.CommonUtil;
import org.eclipse.emf.common.util.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SegmentSequence
implements CharSequence {
    static final String[] EMPTY_ARRAY = new String[0];
    static final String[] EMPTY_STRING_ARRAY = new String[]{""};
    protected static final SegmentSequencePool POOL = new SegmentSequencePool(CommonUtil.REFERENCE_CLEARING_QUEUE);
    protected static final StringArrayPool STRING_ARRAY_POOL = new StringArrayPool(CommonUtil.REFERENCE_CLEARING_QUEUE);
    protected final int hashCode;
    protected final String delimiter;
    protected final String[] segments;
    protected WeakReference<String> toString;

    SegmentSequence(String delimiter, String[] segments, int hashCode) {
        this.delimiter = delimiter;
        this.segments = segments;
        this.hashCode = hashCode;
    }

    public SegmentSequence append(SegmentSequence segmentSequence) {
        if (this.segments == EMPTY_ARRAY) {
            if (this.delimiter != segmentSequence.delimiter) {
                String[] splitSegments = SegmentSequence.split(this.delimiter, segmentSequence.segments, segmentSequence.segments.length);
                return POOL.intern(false, false, this.delimiter, splitSegments, splitSegments.length);
            }
            return segmentSequence;
        }
        if (this.delimiter != segmentSequence.delimiter) {
            String[] splitSegments = SegmentSequence.split(this.delimiter, segmentSequence.segments, segmentSequence.segments.length);
            return POOL.intern(this.hashCode, this.delimiter, this.segments, splitSegments, false);
        }
        return POOL.intern(this.hashCode, this.delimiter, this.segments, segmentSequence.segments, false);
    }

    public SegmentSequence append(String segment) {
        if (this.segments == EMPTY_ARRAY) {
            return SegmentSequence.create(this.delimiter, segment);
        }
        if (segment.contains(this.delimiter)) {
            return this.append(SegmentSequence.create(this.delimiter, segment));
        }
        return POOL.intern(this.hashCode, this.delimiter, this.segments, segment);
    }

    public SegmentSequence append(String ... segments) {
        if (this.segments == EMPTY_ARRAY) {
            return SegmentSequence.create(this.delimiter, segments);
        }
        String[] splitSegments = SegmentSequence.split(this.delimiter, segments, segments.length);
        return POOL.intern(this.hashCode, this.delimiter, this.segments, splitSegments, true);
    }

    @Override
    public int length() {
        int segmentCount = this.segments.length;
        switch (segmentCount) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.segments[0].length();
            }
        }
        WeakReference<String> toString = this.toString;
        if (toString != null) {
            String result = (String)toString.get();
            if (result == null) {
                toString.clear();
            } else {
                return result.length();
            }
        }
        int count = this.delimiter.length() * (segmentCount - 1);
        int i = 0;
        while (i < segmentCount) {
            count += this.segments[i].length();
            ++i;
        }
        return count;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        int segmentCount = this.segments.length;
        switch (segmentCount) {
            case 0: {
                return "";
            }
            case 1: {
                return this.segments[0];
            }
        }
        WeakReference<String> toString = this.toString;
        if (toString != null) {
            String result = (String)toString.get();
            if (result == null) {
                toString.clear();
            } else {
                return result;
            }
        }
        int count = this.delimiter.length() * (segmentCount - 1);
        int i = 0;
        while (i < segmentCount) {
            count += this.segments[i].length();
            ++i;
        }
        char[] buffer = new char[count];
        String segment = this.segments[0];
        int length = segment.length();
        segment.getChars(0, length, buffer, 0);
        int i2 = 1;
        int index = length;
        int delimiterLength = this.delimiter.length();
        while (i2 < segmentCount) {
            this.delimiter.getChars(0, delimiterLength, buffer, index);
            segment = this.segments[i2];
            length = segment.length();
            segment.getChars(0, length, buffer, index += delimiterLength);
            index += length;
            ++i2;
        }
        String result = CommonUtil.intern(buffer, 0, count);
        this.toString = POOL.newCachedToString(this, result);
        return result;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String[] segments() {
        return (String[])this.segments.clone();
    }

    public String[] subSegments(int start) {
        return this.subSegments(start, this.segments.length);
    }

    public String[] subSegments(int start, int end) {
        SegmentSequence.rangeCheck(this.segments, start, end);
        int count = end - start;
        String[] result = new String[count];
        System.arraycopy(this.segments, start, result, 0, count);
        return result;
    }

    static void rangeCheck(Object[] array, int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start=" + start);
        }
        if (start > array.length) {
            throw new IndexOutOfBoundsException("end = " + end);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start=" + start + " > " + "end=" + end);
        }
    }

    public List<String> segmentsList() {
        return this.segments == EMPTY_ARRAY ? Collections.emptyList() : new UnmodifiableArrayList<String>(this.segments);
    }

    public List<String> subSegmentsList(int start) {
        return this.subSegmentsList(start, this.segments.length);
    }

    public List<String> subSegmentsList(int start, int end) {
        SegmentSequence.rangeCheck(this.segments, start, end);
        return new UnmodifiableArraySubList<String>(this.segments, start, end);
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public String segment(int index) {
        return this.segments[index];
    }

    public String lastSegment() {
        return this.segments == EMPTY_ARRAY ? null : this.segments[this.segments.length - 1];
    }

    public String firstSegment() {
        return this.segments == EMPTY_ARRAY ? null : this.segments[0];
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected boolean matches(String delimiter, String string) {
        String segment;
        WeakReference<String> toString;
        if (!this.delimiter.equals(delimiter)) {
            return false;
        }
        int segmentCount = this.segments.length;
        if (segmentCount == 0) {
            return string.length() == 0 && delimiter.length() == 0;
        }
        if (segmentCount == 1) {
            return this.segments[0].equals(string);
        }
        if (this.toString != null && (toString = this.toString) != null) {
            String stringValue = (String)toString.get();
            if (stringValue == null) {
                toString.clear();
            } else {
                return stringValue.equals(string);
            }
        }
        if (!string.startsWith(segment = this.segments[0])) {
            return false;
        }
        int i = 1;
        int index = segment.length();
        int length = string.length();
        int delimiterLength = delimiter.length();
        while (i < segmentCount) {
            if (index >= length || delimiterLength != 0 && !string.startsWith(delimiter, index)) {
                return false;
            }
            segment = this.segments[i];
            if (!string.startsWith(segment, index += delimiterLength)) {
                return false;
            }
            index += segment.length();
            ++i;
        }
        this.toString = POOL.newCachedToString(this, string);
        return true;
    }

    public static SegmentSequence create(String delimiter, String value) {
        return POOL.intern(delimiter, value);
    }

    public static SegmentSequence create(String delimiter) {
        return POOL.intern(false, false, delimiter, EMPTY_ARRAY, 0);
    }

    public static SegmentSequence create(String delimiter, String ... segments) {
        String[] splitSegments = SegmentSequence.split(delimiter, segments, segments.length);
        return POOL.intern(segments == splitSegments && segments != EMPTY_ARRAY, true, delimiter, splitSegments, splitSegments.length);
    }

    protected static SegmentSequence create(String delimiter, String[] segments, int count) {
        String[] splitSegments = SegmentSequence.split(delimiter, segments, count);
        return splitSegments == segments ? POOL.intern(true, true, delimiter, splitSegments, count) : POOL.intern(false, true, delimiter, splitSegments, splitSegments.length);
    }

    protected static String[] split(String delimiter, String[] segments, int length) {
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        if (delimiter.length() == 0) {
            ArrayList<String> collapsedSegments = null;
            int i = 0;
            while (i < length) {
                String segment = segments[i];
                if (segment.length() == 0) {
                    if (collapsedSegments == null) {
                        collapsedSegments = new ArrayList<String>(length - 1);
                        int j = 0;
                        while (j < i) {
                            collapsedSegments.add(segments[j]);
                            ++j;
                        }
                    }
                } else if (collapsedSegments != null) {
                    collapsedSegments.add(segment);
                }
                ++i;
            }
            return collapsedSegments == null ? segments : (collapsedSegments.isEmpty() ? EMPTY_ARRAY : collapsedSegments.toArray(new String[collapsedSegments.size()]));
        }
        ArrayList<String> expandedSegments = null;
        int i = 0;
        while (i < length) {
            String segment = segments[i];
            if (segment.contains(delimiter)) {
                int j;
                String[] subsegments = SegmentSequence.create((String)delimiter, (String)segment).segments;
                if (expandedSegments == null) {
                    expandedSegments = new ArrayList<String>(length + subsegments.length);
                    j = 0;
                    while (j < i) {
                        expandedSegments.add(segments[j]);
                        ++j;
                    }
                }
                j = 0;
                int subsegmentsLength = subsegments.length;
                while (j < subsegmentsLength) {
                    expandedSegments.add(subsegments[j]);
                    ++j;
                }
            } else if (expandedSegments != null) {
                expandedSegments.add(segment);
            }
            ++i;
        }
        return expandedSegments == null ? segments : expandedSegments.toArray(new String[expandedSegments.size()]);
    }

    public static Builder newBuilder(String delimiter) {
        return new Builder(delimiter, 10);
    }

    public static Builder newBuilder(String delimiter, int capacity) {
        return new Builder(delimiter, capacity);
    }

    public static final class Builder {
        protected final String delimiter;
        protected int size;
        protected String[] strings;

        protected Builder(String delimiter, int capacity) {
            if (delimiter == null) {
                throw new NullPointerException("delimiter=null");
            }
            this.delimiter = delimiter;
            this.strings = new String[capacity];
        }

        public Builder append(String string) {
            if (string == null) {
                string = "null";
            }
            if (this.size == this.strings.length) {
                String[] newStrings = new String[2 * this.size];
                System.arraycopy(this.strings, 0, newStrings, 0, this.size);
                this.strings = newStrings;
            }
            this.strings[this.size++] = string;
            return this;
        }

        public Builder append(char c) {
            if (c < '\u0100') {
                this.append(CommonUtil.StringPool.StringsAccessUnit.CHAR_STRINGS[c]);
            } else {
                this.append(String.valueOf(c));
            }
            return this;
        }

        public Builder reverse() {
            int i = 0;
            int j = this.size - 1;
            while (i < j) {
                String string = this.strings[i];
                this.strings[i] = this.strings[j];
                this.strings[j] = string;
                ++i;
                --j;
            }
            return this;
        }

        public SegmentSequence toSegmentSequence() {
            return SegmentSequence.create(this.delimiter, this.strings, this.size);
        }

        public String toString() {
            int size = this.size;
            if (size == 0) {
                return "";
            }
            if (size == 1) {
                return this.strings[0];
            }
            String[] strings = this.strings;
            int delimiterLength = this.delimiter.length();
            String firstString = strings[0];
            int offset = firstString.length();
            int count = offset + (size - 1) * delimiterLength;
            int i = 1;
            while (i < size) {
                count += strings[i].length();
                ++i;
            }
            char[] result = new char[count];
            firstString.getChars(0, offset, result, 0);
            int i2 = 1;
            while (i2 < size) {
                this.delimiter.getChars(0, delimiterLength, result, offset);
                String string = strings[i2];
                int stringLength = string.length();
                string.getChars(0, stringLength, result, offset += delimiterLength);
                offset += stringLength;
                ++i2;
            }
            return new String(result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SegmentSequencePool
    extends Pool<SegmentSequence> {
        private static final long serialVersionUID = 1L;
        protected final StringAccessUnit.Queue stringAccessUnits = new StringAccessUnit.Queue();
        protected final SegmentsAccessUnit.Queue segmentsAccessUnits = new SegmentsAccessUnit.Queue();
        protected final SegmentsAndSegmentAccessUnit.Queue segmentsAndSegmentAccessUnits = new SegmentsAndSegmentAccessUnit.Queue();
        protected final SegmentsAndSegmentsAccessUnit.Queue segmentsAndSegmentsAccessUnits = new SegmentsAndSegmentsAccessUnit.Queue();
        protected final ReferenceQueue<String> cachedToStrings = this.externalQueue == null ? new ReferenceQueue() : null;

        public SegmentSequencePool(ReferenceQueue<Object> queue) {
            super(1031, null, queue);
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            Reference<String> cachedToString;
            while ((cachedToString = this.cachedToStrings.poll()) != null) {
                cachedToString.clear();
            }
            return;
        }

        protected WeakReference<String> newCachedToString(SegmentSequence segmentSequence, String string) {
            return this.cachedToStrings == null ? new CachedToString(segmentSequence, string, this.externalQueue) : new CachedToString(segmentSequence, string, this.cachedToStrings);
        }

        protected SegmentSequence intern(String delimiter, String value) {
            if (value == null) {
                return null;
            }
            StringAccessUnit accessUnit = this.stringAccessUnits.pop(false);
            accessUnit.setValue(delimiter, value);
            return this.doIntern(false, accessUnit);
        }

        protected SegmentSequence intern(boolean needsCopying, boolean needsToIntern, String delimiter, String[] segments, int count) {
            SegmentsAccessUnit accessUnit = this.segmentsAccessUnits.pop(false);
            accessUnit.setValue(needsCopying, needsToIntern, delimiter, segments, count);
            return this.doIntern(false, accessUnit);
        }

        protected SegmentSequence intern(int hashCode, String delimiter, String[] segments, String segment) {
            SegmentsAndSegmentAccessUnit accessUnit = this.segmentsAndSegmentAccessUnits.pop(false);
            accessUnit.setValue(hashCode, delimiter, segments, segment);
            return this.doIntern(false, accessUnit);
        }

        protected SegmentSequence intern(int hashCode, String delimiter, String[] segments1, String[] segments2, boolean needsToIntern) {
            SegmentsAndSegmentsAccessUnit accessUnit = this.segmentsAndSegmentsAccessUnits.pop(false);
            accessUnit.setValue(hashCode, delimiter, segments1, segments2, needsToIntern);
            return this.doIntern(false, accessUnit);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class AccessUnitBase
        extends Pool.AccessUnit<SegmentSequence> {
            protected AccessUnitBase(Pool.AccessUnit.Queue<SegmentSequence> queue) {
                super(queue);
            }

            @Override
            protected SegmentSequence getValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void setValue(SegmentSequence value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected boolean setArbitraryValue(Object value) {
                throw new UnsupportedOperationException();
            }

            protected static int hashCode(int initialHashCode, int delimiterHashCode, int delimiterPowerOf31, String[] segments, int length) {
                if (length == 0) {
                    return initialHashCode;
                }
                String segment = segments[0];
                int hashCode = (initialHashCode == 0 ? 0 : initialHashCode * CommonUtil.powerOf31(segment.length())) + segment.hashCode();
                int i = 1;
                while (i < length) {
                    hashCode = hashCode * delimiterPowerOf31 + delimiterHashCode;
                    segment = segments[i];
                    hashCode = hashCode * CommonUtil.powerOf31(segment.length()) + segment.hashCode();
                    ++i;
                }
                return hashCode;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class CachedToString
        extends WeakReference<String> {
            protected final SegmentSequence segmentSequence;

            public CachedToString(SegmentSequence segmentSequence, String string, ReferenceQueue<? super String> queue) {
                super(string, queue);
                this.segmentSequence = segmentSequence;
            }

            @Override
            public void clear() {
                this.segmentSequence.toString = null;
                super.clear();
            }
        }

        protected static class SegmentsAccessUnit
        extends AccessUnitBase {
            protected boolean needsCopying;
            protected boolean needsToIntern;
            protected String delimiter;
            protected String[] segments;
            protected int count;

            protected SegmentsAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(boolean needsCopying, boolean needsToIntern, String delimiter, String[] segments, int count) {
                this.needsCopying = needsCopying;
                this.needsToIntern = needsToIntern;
                this.delimiter = delimiter;
                this.segments = segments;
                this.count = count;
                this.hashCode = SegmentsAccessUnit.hashCode(0, delimiter.hashCode(), CommonUtil.powerOf31(delimiter.length()), segments, count);
            }

            public SegmentSequence getInternalizedValue() {
                return new SegmentSequence(this.delimiter, STRING_ARRAY_POOL.intern(this.needsCopying, this.needsToIntern, this.segments, this.count), this.hashCode);
            }

            protected boolean matches(SegmentSequence value) {
                return this.delimiter.equals(value.delimiter) && SegmentsAccessUnit.equals(this.segments, this.count, value.segments);
            }

            protected static boolean equals(String[] segments1, int length, String[] segments2) {
                if (segments2.length != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (!segments1[i].equals(segments2[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            public void reset(boolean isExclusive) {
                this.delimiter = null;
                this.segments = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<SegmentSequence> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SegmentsAccessUnit pop(boolean isExclusive) {
                    return (SegmentsAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<SegmentSequence> newAccessUnit() {
                    return new SegmentsAccessUnit(this);
                }
            }
        }

        protected static class SegmentsAndSegmentAccessUnit
        extends AccessUnitBase {
            protected String delimiter;
            protected String[] segments;
            protected String segment;

            protected SegmentsAndSegmentAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(int hashCode, String delimiter, String[] segments, String segment) {
                this.delimiter = delimiter;
                this.segments = segments;
                this.segment = segment;
                hashCode = hashCode * CommonUtil.powerOf31(delimiter.length()) + delimiter.hashCode();
                this.hashCode = hashCode = hashCode * CommonUtil.powerOf31(segment.length()) + segment.hashCode();
            }

            public SegmentSequence getInternalizedValue() {
                return new SegmentSequence(this.delimiter, STRING_ARRAY_POOL.intern(this.segments, this.segments.length, this.segment, true), this.hashCode);
            }

            protected boolean matches(SegmentSequence value) {
                String[] entrySegments;
                int length;
                if (this.delimiter.equals(value.delimiter) && (length = this.segments.length) + 1 == (entrySegments = value.segments).length) {
                    int i = 0;
                    while (i < length) {
                        if (entrySegments[i] != this.segments[i]) {
                            return false;
                        }
                        ++i;
                    }
                    if (this.segment.equals(entrySegments[i])) {
                        return true;
                    }
                }
                return false;
            }

            public void reset(boolean isExclusive) {
                this.delimiter = null;
                this.segments = null;
                this.segment = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<SegmentSequence> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SegmentsAndSegmentAccessUnit pop(boolean isExclusive) {
                    return (SegmentsAndSegmentAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<SegmentSequence> newAccessUnit() {
                    return new SegmentsAndSegmentAccessUnit(this);
                }
            }
        }

        protected static class SegmentsAndSegmentsAccessUnit
        extends AccessUnitBase {
            protected String delimiter;
            protected String[] segments1;
            protected String[] segments2;
            protected boolean needsToIntern;

            protected SegmentsAndSegmentsAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(int hashCode, String delimiter, String[] segments1, String[] segments2, boolean needsToIntern) {
                this.delimiter = delimiter;
                this.segments1 = segments1;
                this.segments2 = segments2;
                this.needsToIntern = needsToIntern;
                if (segments2.length > 0) {
                    int delimiterHashCode = delimiter.hashCode();
                    int delimiterPowerOf31 = CommonUtil.powerOf31(delimiter.length());
                    hashCode = hashCode * delimiterPowerOf31 + delimiterHashCode;
                    hashCode = SegmentsAndSegmentsAccessUnit.hashCode(hashCode, delimiterHashCode, delimiterPowerOf31, segments2, segments2.length);
                }
                this.hashCode = hashCode;
            }

            public SegmentSequence getInternalizedValue() {
                return new SegmentSequence(this.delimiter, STRING_ARRAY_POOL.intern(this.segments1, this.segments2, this.needsToIntern), this.hashCode);
            }

            protected boolean matches(SegmentSequence value) {
                if (this.delimiter.equals(value.delimiter)) {
                    int length1 = this.segments1.length;
                    int length2 = this.segments2.length;
                    int length = length1 + length2;
                    String[] entrySegments = value.segments;
                    if (length == entrySegments.length) {
                        int i = 0;
                        while (i < length1) {
                            if (entrySegments[i] != this.segments1[i]) {
                                return false;
                            }
                            ++i;
                        }
                        if (this.needsToIntern) {
                            int j = 0;
                            while (j < length2) {
                                if (!entrySegments[i].equals(this.segments2[j])) {
                                    return false;
                                }
                                ++i;
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < length2) {
                                if (entrySegments[i] != this.segments2[j]) {
                                    return false;
                                }
                                ++i;
                                ++j;
                            }
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }

            public void reset(boolean isExclusive) {
                this.delimiter = null;
                this.segments1 = null;
                this.segments2 = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<SegmentSequence> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SegmentsAndSegmentsAccessUnit pop(boolean isExclusive) {
                    return (SegmentsAndSegmentsAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<SegmentSequence> newAccessUnit() {
                    return new SegmentsAndSegmentsAccessUnit(this);
                }
            }
        }

        protected static class StringAccessUnit
        extends AccessUnitBase {
            protected char[] buffer = new char[100];
            protected char[] delimiterBuffer = new char[2];
            protected String[] segmentBuffer = new String[100];
            protected String delimiter;
            protected String string;
            protected CommonUtil.StringPool.CharactersAccessUnit charactersAccessUnit = new CommonUtil.StringPool.CharactersAccessUnit(null);

            protected StringAccessUnit(Queue queue) {
                super(queue);
            }

            protected String internString(char[] characters, int offset, int count, int hashCode) {
                this.charactersAccessUnit.setValue(characters, offset, count, hashCode);
                return CommonUtil.STRING_POOL.doIntern(false, this.charactersAccessUnit);
            }

            protected void setValue(String delimiter, String value) {
                this.delimiter = delimiter;
                this.string = value;
                this.hashCode = value.hashCode();
            }

            /*
             * Unable to fully structure code
             */
            public SegmentSequence getInternalizedValue() {
                delimiterLength = this.delimiter.length();
                if (delimiterLength == 0) {
                    if (this.string.length() == 0) {
                        return new SegmentSequence(this.delimiter, SegmentSequence.EMPTY_ARRAY, this.hashCode);
                    }
                    return new SegmentSequence(this.delimiter, SegmentSequence.STRING_ARRAY_POOL.intern(this.string, true), this.hashCode);
                }
                length = this.string.length();
                if (this.buffer.length < length) {
                    this.buffer = new char[length];
                }
                if (this.delimiterBuffer.length < delimiterLength) {
                    this.delimiterBuffer = new char[delimiterLength];
                }
                this.string.getChars(0, length, this.buffer, 0);
                this.delimiter.getChars(0, delimiterLength, this.delimiterBuffer, 0);
                segmentCount = 0;
                segmentHashCode = 0;
                start = 0;
                delimiterChar = this.delimiterBuffer[0];
                i = start;
                delimiterIndex = 0;
                while (i < length) {
                    c = this.buffer[i];
                    if (c != delimiterChar) ** GOTO lbl31
                    if (++delimiterIndex == delimiterLength) {
                        this.ensureSegmentCapacity(segmentCount);
                        this.segmentBuffer[segmentCount++] = this.internString(this.buffer, start, i - start, segmentHashCode);
                        start = i + 1;
                        segmentHashCode = 0;
                        delimiterIndex = 0;
                        delimiterChar = this.delimiterBuffer[0];
                    } else {
                        delimiterChar = this.delimiterBuffer[delimiterIndex];
lbl31:
                        // 2 sources

                        segmentHashCode = 31 * segmentHashCode + c;
                    }
                    ++i;
                }
                this.ensureSegmentCapacity(segmentCount);
                this.segmentBuffer[segmentCount++] = this.internString(this.buffer, start, length - start, segmentHashCode);
                segmentSequence = new SegmentSequence(this.delimiter, SegmentSequence.STRING_ARRAY_POOL.intern(this.segmentBuffer, 0, segmentCount), this.hashCode);
                if (segmentCount > 1) {
                    segmentSequence.toString = SegmentSequence.POOL.newCachedToString(segmentSequence, this.string);
                }
                return segmentSequence;
            }

            protected boolean matches(SegmentSequence value) {
                return value.matches(this.delimiter, this.string);
            }

            protected void ensureSegmentCapacity(int segmentCount) {
                if (segmentCount >= this.segmentBuffer.length) {
                    String[] oldSegments = this.segmentBuffer;
                    this.segmentBuffer = new String[2 * this.segmentBuffer.length];
                    System.arraycopy(oldSegments, 0, this.segmentBuffer, 0, segmentCount);
                }
            }

            public void reset(boolean isExclusive) {
                this.delimiter = null;
                this.string = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<SegmentSequence> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public StringAccessUnit pop(boolean isExclusive) {
                    return (StringAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<SegmentSequence> newAccessUnit() {
                    return new StringAccessUnit(this);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StringArrayPool
    extends Pool<String[]> {
        private static final long serialVersionUID = 1L;
        protected final StringAccessUnit.Queue stringAccessUnits = new StringAccessUnit.Queue();
        protected final SubstringAccessUnit.Queue substringAccessUnits = new SubstringAccessUnit.Queue();
        protected final SegmentsAndSegmentAccessUnit.Queue segmentsAndSegmentAccessUnits = new SegmentsAndSegmentAccessUnit.Queue();
        protected final SegmentsAndSubsegmentAccessUnit.Queue segmentsAndSubsegmentAccessUnits = new SegmentsAndSubsegmentAccessUnit.Queue();
        protected final SegmentsAndSegmentCountAccessUnit.Queue segmentsAndSegmentCountAccessUnits = new SegmentsAndSegmentCountAccessUnit.Queue();
        protected final SegmentsAccessUnit.Queue segmentsAccessUnits;
        protected final SegmentsAndSegmentsAccessUnit.Queue segmentsAndSegmentsAccessUnits = new SegmentsAndSegmentsAccessUnit.Queue();
        protected final SubsegmentsAndSubsegmentsAccessUnit.Queue subsegmentsAndSubsegmentsAccessUnits = new SubsegmentsAndSubsegmentsAccessUnit.Queue();

        public StringArrayPool(ReferenceQueue<Object> queue) {
            super(1031, new SegmentsAccessUnit.Queue(), queue);
            this.addEntry(1, this.newEntry(EMPTY_ARRAY, 1));
            this.addEntry(31, this.newEntry(EMPTY_STRING_ARRAY, 31));
            this.segmentsAccessUnits = (SegmentsAccessUnit.Queue)this.primaryAccessUnits;
        }

        @Override
        protected int hashCode(String[] object) {
            return Arrays.hashCode(object);
        }

        @Override
        protected boolean equals(String[] object, String[] otherObject) {
            return Arrays.equals(object, otherObject);
        }

        @Override
        protected String[] asInstance(Object object) {
            return object instanceof String[] ? (String[])object : null;
        }

        protected String[] intern(String segment, boolean needsInterning) {
            StringAccessUnit accessUnit = this.stringAccessUnits.pop(false);
            accessUnit.setValue(segment, needsInterning);
            return this.doIntern(false, accessUnit);
        }

        protected String[] intern(String segment, int offset, int count, int hashCode) {
            SubstringAccessUnit accessUnit = this.substringAccessUnits.pop(false);
            accessUnit.setValue(segment, offset, count, hashCode);
            return this.doIntern(false, accessUnit);
        }

        protected String[] intern(String[] segments, int segmentCount, String segment, boolean needsInterning) {
            if (segmentCount == 0) {
                return this.intern(segment, needsInterning);
            }
            SegmentsAndSegmentAccessUnit accessUnit = this.segmentsAndSegmentAccessUnits.pop(false);
            accessUnit.setValue(segments, segmentCount, segment, needsInterning);
            return this.doIntern(false, accessUnit);
        }

        protected String[] intern(int hashCode, String[] segments, int segmentCount, String segment, int offset, int count, int segmentHashCode) {
            if (segments.length == 0) {
                return this.intern(segment, offset, count, segmentHashCode);
            }
            SegmentsAndSubsegmentAccessUnit accessUnit = this.segmentsAndSubsegmentAccessUnits.pop(false);
            accessUnit.setValue(hashCode, segments, segmentCount, segment, offset, count, segmentHashCode);
            return this.doIntern(false, accessUnit);
        }

        protected String[] intern(String[] segments, int segmentCount, String segment, int offset, int count, int segmentHashCode) {
            if (segments.length == 0) {
                return this.intern(segment, offset, count, segmentHashCode);
            }
            SegmentsAndSubsegmentAccessUnit accessUnit = this.segmentsAndSubsegmentAccessUnits.pop(false);
            accessUnit.setValue(segments, segmentCount, segment, offset, count, segmentHashCode);
            return this.doIntern(false, accessUnit);
        }

        protected String[] intern(String[] segments, int offset, int segmentCount) {
            SegmentsAndSegmentCountAccessUnit accessUnit = this.segmentsAndSegmentCountAccessUnits.pop(false);
            accessUnit.setValue(segments, offset, segmentCount);
            return this.doIntern(false, accessUnit);
        }

        protected String[] intern(String[] segments, int offset, int segmentCount, int hashCode) {
            SegmentsAndSegmentCountAccessUnit accessUnit = this.segmentsAndSegmentCountAccessUnits.pop(false);
            accessUnit.setValue(segments, offset, segmentCount, hashCode);
            return this.doIntern(false, accessUnit);
        }

        protected String[] intern(boolean needsCopying, boolean needsToIntern, String[] segments, int count) {
            if (segments == null) {
                return EMPTY_ARRAY;
            }
            SegmentsAccessUnit accessUnit = this.segmentsAccessUnits.pop(false);
            accessUnit.setValue(needsCopying, needsToIntern, segments, count);
            return this.doIntern(false, accessUnit);
        }

        protected String[] intern(String[] segments1, String[] segments2, boolean needsToIntern) {
            SegmentsAndSegmentsAccessUnit accessUnit = this.segmentsAndSegmentsAccessUnits.pop(false);
            accessUnit.setValue(segments1, segments2, needsToIntern);
            return this.doIntern(false, accessUnit);
        }

        protected String[] intern(String[] segments1, int offset1, int count1, String[] segments2, int offset2, int count2) {
            SubsegmentsAndSubsegmentsAccessUnit accessUnit = this.subsegmentsAndSubsegmentsAccessUnits.pop(false);
            accessUnit.setValue(segments1, offset1, count1, segments2, offset2, count2);
            return this.doIntern(false, accessUnit);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class AccessUnitBase
        extends Pool.AccessUnit<String[]> {
            protected CommonUtil.StringPool.StringAccessUnit stringAccessUnit = new CommonUtil.StringPool.StringAccessUnit(CommonUtil.STRING_POOL, null);
            protected CommonUtil.StringPool.SubstringAccessUnit substringAccessUnit = new CommonUtil.StringPool.SubstringAccessUnit(null);

            protected AccessUnitBase(Pool.AccessUnit.Queue<String[]> queue) {
                super(queue);
            }

            @Override
            protected String[] getValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void setValue(String[] value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected boolean setArbitraryValue(Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected boolean matches(String[] value) {
                throw new UnsupportedOperationException();
            }

            protected String internString(String string) {
                this.stringAccessUnit.setValue(string);
                return CommonUtil.STRING_POOL.doIntern(false, this.stringAccessUnit);
            }

            protected String internString(String string, int offset, int count, int hashCode) {
                if (count == 0) {
                    return "";
                }
                this.substringAccessUnit.setValue(string, offset, count, hashCode);
                return CommonUtil.STRING_POOL.doIntern(false, this.substringAccessUnit);
            }
        }

        protected static final class SegmentsAccessUnit
        extends AccessUnitBase {
            protected boolean needsCopying;
            protected boolean needsToIntern;
            protected String[] segments;
            protected int count;

            protected SegmentsAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(String[] value) {
                this.setValue(true, true, value, value.length);
            }

            protected boolean setArbitraryValue(Object value) {
                if (!(value instanceof String[])) {
                    return false;
                }
                this.setValue((String[])value);
                return true;
            }

            protected void setValue(boolean needsCopying, boolean needsToIntern, String[] segments, int count) {
                this.needsCopying = needsCopying;
                this.needsToIntern = needsToIntern;
                this.segments = segments;
                this.count = count;
                int hashCode = 1;
                int i = 0;
                while (i < count) {
                    String value = segments[i];
                    hashCode = 31 * hashCode + value.hashCode();
                    ++i;
                }
                this.hashCode = hashCode;
            }

            protected boolean matches(String[] value) {
                int length = value.length;
                if (length != this.count) {
                    return false;
                }
                if (this.needsToIntern) {
                    int i = 0;
                    while (i < length) {
                        if (!value[i].equals(this.segments[i])) {
                            return false;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < length) {
                        if (value[i] != this.segments[i]) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }

            public String[] getInternalizedValue() {
                String[] newSegments;
                block7: {
                    int length;
                    block6: {
                        length = this.count;
                        newSegments = this.segments;
                        if (!this.needsCopying) break block6;
                        if (length == 0) {
                            newSegments = EMPTY_ARRAY;
                        } else {
                            newSegments = new String[length];
                            if (this.needsToIntern) {
                                int i = 0;
                                while (i < length) {
                                    newSegments[i] = this.internString(this.segments[i]);
                                    ++i;
                                }
                            } else {
                                System.arraycopy(this.segments, 0, newSegments, 0, length);
                            }
                        }
                        break block7;
                    }
                    if (!this.needsToIntern) break block7;
                    int i = 0;
                    while (i < length) {
                        this.segments[i] = this.internString(this.segments[i]);
                        ++i;
                    }
                }
                return newSegments;
            }

            public void reset(boolean isExclusive) {
                this.segments = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<String[]> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SegmentsAccessUnit pop(boolean isExclusive) {
                    return (SegmentsAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String[]> newAccessUnit() {
                    return new SegmentsAccessUnit(this);
                }
            }
        }

        protected static class SegmentsAndSegmentAccessUnit
        extends AccessUnitBase {
            protected String[] segments;
            protected int segmentCount;
            protected String segment;
            protected boolean needsInterning;

            protected SegmentsAndSegmentAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(String[] segments, int segmentCount, String segment, boolean needsInterning) {
                assert (segments.length > 0 && segmentCount > 0);
                this.segments = segments;
                this.segmentCount = segmentCount;
                this.segment = segment;
                this.needsInterning = needsInterning;
                int hashCode = 1;
                int i = 0;
                while (i < segmentCount) {
                    String value = segments[i];
                    hashCode = 31 * hashCode + value.hashCode();
                    ++i;
                }
                this.hashCode = 31 * hashCode + segment.hashCode();
            }

            protected boolean matches(String[] value) {
                int length = this.segmentCount;
                if (length + 1 != value.length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (value[i] != this.segments[i]) {
                        return false;
                    }
                    ++i;
                }
                return this.needsInterning ? this.segment.equals(value[length]) : this.segment == value[length];
            }

            public String[] getInternalizedValue() {
                int length = this.segmentCount;
                String[] newSegments = new String[length + 1];
                System.arraycopy(this.segments, 0, newSegments, 0, length);
                newSegments[length] = this.needsInterning ? this.internString(this.segment) : this.segment;
                return newSegments;
            }

            public void reset(boolean isExclusive) {
                this.segments = null;
                this.segment = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<String[]> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SegmentsAndSegmentAccessUnit pop(boolean isExclusive) {
                    return (SegmentsAndSegmentAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String[]> newAccessUnit() {
                    return new SegmentsAndSegmentAccessUnit(this);
                }
            }
        }

        protected static class SegmentsAndSegmentCountAccessUnit
        extends AccessUnitBase {
            protected String[] segments;
            protected int offset;
            protected int segmentCount;

            protected SegmentsAndSegmentCountAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(String[] segments, int offset, int segmentCount) {
                this.segments = segments;
                this.offset = offset;
                this.segmentCount = segmentCount;
                int hashCode = 1;
                int i = 0;
                while (i < segmentCount) {
                    hashCode = 31 * hashCode + segments[offset + i].hashCode();
                    ++i;
                }
                this.hashCode = hashCode;
            }

            protected void setValue(String[] segments, int offset, int segmentCount, int hashCode) {
                this.segments = segments;
                this.offset = offset;
                this.segmentCount = segmentCount;
                this.hashCode = hashCode;
            }

            protected boolean matches(String[] value) {
                int length = value.length;
                if (length != this.segmentCount) {
                    return false;
                }
                int i = 0;
                int offset = this.offset;
                while (i < length) {
                    if (value[i] != this.segments[offset + i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            public String[] getInternalizedValue() {
                String[] newSegments = new String[this.segmentCount];
                System.arraycopy(this.segments, this.offset, newSegments, 0, this.segmentCount);
                return newSegments;
            }

            public void reset(boolean isExclusive) {
                this.segments = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<String[]> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SegmentsAndSegmentCountAccessUnit pop(boolean isExclusive) {
                    return (SegmentsAndSegmentCountAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String[]> newAccessUnit() {
                    return new SegmentsAndSegmentCountAccessUnit(this);
                }
            }
        }

        protected static class SegmentsAndSegmentsAccessUnit
        extends AccessUnitBase {
            protected String[] segments1;
            protected String[] segments2;
            protected boolean needsToIntern;

            protected SegmentsAndSegmentsAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(String[] segments1, String[] segments2, boolean needsToIntern) {
                String value;
                this.segments1 = segments1;
                this.segments2 = segments2;
                this.needsToIntern = needsToIntern;
                int hashCode = 1;
                String[] stringArray = segments1;
                int n = segments1.length;
                int n2 = 0;
                while (n2 < n) {
                    value = stringArray[n2];
                    hashCode = 31 * hashCode + value.hashCode();
                    ++n2;
                }
                stringArray = segments2;
                n = segments2.length;
                n2 = 0;
                while (n2 < n) {
                    value = stringArray[n2];
                    hashCode = 31 * hashCode + value.hashCode();
                    ++n2;
                }
                this.hashCode = hashCode;
            }

            protected boolean matches(String[] value) {
                int length1 = this.segments1.length;
                int length2 = this.segments2.length;
                if (length1 + length2 != value.length) {
                    return false;
                }
                int i = 0;
                while (i < length1) {
                    if (this.segments1[i] != value[i]) {
                        return false;
                    }
                    ++i;
                }
                if (this.needsToIntern) {
                    int j = 0;
                    while (j < length2) {
                        if (!this.segments2[j].equals(value[i])) {
                            return false;
                        }
                        ++j;
                        ++i;
                    }
                } else {
                    int j = 0;
                    while (j < length2) {
                        if (this.segments2[j] != value[i]) {
                            return false;
                        }
                        ++j;
                        ++i;
                    }
                }
                return true;
            }

            public String[] getInternalizedValue() {
                int length1 = this.segments1.length;
                int length2 = this.segments2.length;
                int length = length1 + length2;
                String[] newSegments = new String[length];
                System.arraycopy(this.segments1, 0, newSegments, 0, length1);
                if (this.needsToIntern) {
                    int i = 0;
                    int j = length1;
                    while (i < length2) {
                        newSegments[j] = this.internString(this.segments2[i]);
                        ++i;
                        ++j;
                    }
                } else {
                    System.arraycopy(this.segments2, 0, newSegments, length1, length2);
                }
                return newSegments;
            }

            public void reset(boolean isExclusive) {
                this.segments1 = null;
                this.segments2 = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<String[]> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SegmentsAndSegmentsAccessUnit pop(boolean isExclusive) {
                    return (SegmentsAndSegmentsAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String[]> newAccessUnit() {
                    return new SegmentsAndSegmentsAccessUnit(this);
                }
            }
        }

        protected static class SegmentsAndSubsegmentAccessUnit
        extends AccessUnitBase {
            protected String[] segments;
            protected int segmentCount;
            protected String segment;
            protected int offset;
            protected int count;
            protected int segmentHashCode;

            protected SegmentsAndSubsegmentAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(int hashCode, String[] segments, int segmentCount, String segment, int offset, int count, int segmentHashCode) {
                assert (segments.length > 0);
                this.segments = segments;
                this.segmentCount = segmentCount;
                this.segment = segment;
                this.offset = offset;
                this.count = count;
                this.segmentHashCode = segmentHashCode;
                this.hashCode = 31 * hashCode + segmentHashCode;
            }

            protected void setValue(String[] segments, int segmentCount, String segment, int offset, int count, int segmentHashCode) {
                assert (segments.length > 0);
                this.segments = segments;
                this.segmentCount = segmentCount;
                this.segment = segment;
                this.offset = offset;
                this.count = count;
                this.segmentHashCode = segmentHashCode;
                int hashCode = 1;
                int i = 0;
                while (i < segmentCount) {
                    String value = segments[i];
                    hashCode = 31 * hashCode + value.hashCode();
                    ++i;
                }
                this.hashCode = 31 * hashCode + segmentHashCode;
            }

            protected boolean matches(String[] value) {
                int length = this.segmentCount;
                if (length + 1 != value.length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (value[i] != this.segments[i]) {
                        return false;
                    }
                    ++i;
                }
                String lastValue = value[length];
                return lastValue.length() == this.count && this.segment.regionMatches(this.offset, lastValue, 0, this.count);
            }

            public String[] getInternalizedValue() {
                int length = this.segmentCount;
                String[] newSegments = new String[length + 1];
                System.arraycopy(this.segments, 0, newSegments, 0, length);
                newSegments[length] = this.internString(this.segment, this.offset, this.count, this.segmentHashCode);
                return newSegments;
            }

            public void reset(boolean isExclusive) {
                this.segments = null;
                this.segment = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<String[]> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SegmentsAndSubsegmentAccessUnit pop(boolean isExclusive) {
                    return (SegmentsAndSubsegmentAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String[]> newAccessUnit() {
                    return new SegmentsAndSubsegmentAccessUnit(this);
                }
            }
        }

        protected static class StringAccessUnit
        extends AccessUnitBase {
            protected String value;
            protected boolean needsInterning;

            protected StringAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(String value, boolean needsInterning) {
                this.value = value;
                this.needsInterning = needsInterning;
                this.hashCode = 31 + value.hashCode();
            }

            protected boolean matches(String[] value) {
                return value.length == 1 && this.value.equals(value[0]);
            }

            public String[] getInternalizedValue() {
                return new String[]{this.needsInterning ? this.internString(this.value) : this.value};
            }

            public void reset(boolean isExclusive) {
                this.value = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<String[]> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public StringAccessUnit pop(boolean isExclusive) {
                    return (StringAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String[]> newAccessUnit() {
                    return new StringAccessUnit(this);
                }
            }
        }

        protected static class SubsegmentsAndSubsegmentsAccessUnit
        extends AccessUnitBase {
            protected String[] segments1;
            protected int offset1;
            protected int count1;
            protected String[] segments2;
            protected int offset2;
            protected int count2;

            protected SubsegmentsAndSubsegmentsAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(String[] segments1, int offset1, int count1, String[] segments2, int offset2, int count2) {
                this.segments1 = segments1;
                this.offset1 = offset1;
                this.count1 = count1;
                this.segments2 = segments2;
                this.offset2 = offset2;
                this.count2 = count2;
                int hashCode = 1;
                int i = 0;
                while (i < count1) {
                    hashCode = 31 * hashCode + segments1[offset1 + i].hashCode();
                    ++i;
                }
                i = 0;
                while (i < count2) {
                    hashCode = 31 * hashCode + segments2[offset2 + i].hashCode();
                    ++i;
                }
                this.hashCode = hashCode;
            }

            protected boolean matches(String[] value) {
                int length1 = this.count1;
                int length2 = this.count2;
                if (length1 + length2 != value.length) {
                    return false;
                }
                int i = 0;
                int offset1 = this.offset1;
                while (i < length1) {
                    if (this.segments1[offset1 + i] != value[i]) {
                        return false;
                    }
                    ++i;
                }
                int j = 0;
                int offset2 = this.offset2;
                while (j < length2) {
                    if (this.segments2[offset2 + j] != value[i]) {
                        return false;
                    }
                    ++j;
                    ++i;
                }
                return true;
            }

            public String[] getInternalizedValue() {
                int length1 = this.count1;
                int length2 = this.count2;
                int length = length1 + length2;
                String[] newSegments = new String[length];
                System.arraycopy(this.segments1, this.offset1, newSegments, 0, length1);
                System.arraycopy(this.segments2, this.offset2, newSegments, length1, length2);
                return newSegments;
            }

            public void reset(boolean isExclusive) {
                this.segments1 = null;
                this.segments2 = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<String[]> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SubsegmentsAndSubsegmentsAccessUnit pop(boolean isExclusive) {
                    return (SubsegmentsAndSubsegmentsAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String[]> newAccessUnit() {
                    return new SubsegmentsAndSubsegmentsAccessUnit(this);
                }
            }
        }

        protected static class SubstringAccessUnit
        extends AccessUnitBase {
            protected String value;
            protected int offset;
            protected int count;

            protected SubstringAccessUnit(Queue queue) {
                super(queue);
            }

            protected void setValue(String value, int offset, int count, int hashCode) {
                this.value = value;
                this.offset = offset;
                this.count = count;
                this.hashCode = 31 + hashCode;
            }

            protected boolean matches(String[] value) {
                if (value.length != 1) {
                    return false;
                }
                String segment = value[0];
                return segment.length() == this.count && this.value.regionMatches(this.offset, segment, 0, this.count);
            }

            public String[] getInternalizedValue() {
                return new String[]{this.internString(this.value, this.offset, this.count, this.hashCode - 31)};
            }

            public void reset(boolean isExclusive) {
                this.value = null;
                super.reset(isExclusive);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Queue
            extends Pool.AccessUnit.Queue<String[]> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SubstringAccessUnit pop(boolean isExclusive) {
                    return (SubstringAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String[]> newAccessUnit() {
                    return new SubstringAccessUnit(this);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableArrayList<E>
    extends AbstractList<E>
    implements RandomAccess {
        protected final E[] array;

        public UnmodifiableArrayList(E[] array) {
            this.array = array;
        }

        @Override
        public E get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableArraySubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        final int start;
        final int end;
        protected final E[] array;

        public UnmodifiableArraySubList(E[] array, int start, int end) {
            this.start = start;
            this.end = end;
            this.array = array;
        }

        @Override
        public E get(int index) {
            if (index < 0 || index > this.end - this.start) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size());
            }
            return this.array[this.start + index];
        }

        @Override
        public int size() {
            return this.end - this.start;
        }
    }
}

