/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.compress.ContentCodecRegistry;
import org.apache.hc.client5.http.entity.compress.ContentCoding;
import org.apache.hc.client5.http.impl.ContentCodingSupport;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class ContentCompressionExec
implements ExecChainHandler {
    private final Header acceptEncoding;
    private final Lookup<UnaryOperator<HttpEntity>> decoderRegistry;
    private final int maxCodecListLen;

    public ContentCompressionExec(List<String> acceptEncoding, Lookup<UnaryOperator<HttpEntity>> decoderRegistry, int maxCodecListLen) {
        this.acceptEncoding = MessageSupport.headerOfTokens((String)"Accept-Encoding", (List)((List)Args.notEmpty(acceptEncoding, (String)"Encoding list")));
        this.decoderRegistry = (Lookup)Args.notNull(decoderRegistry, (String)"Decoder register");
        this.maxCodecListLen = maxCodecListLen;
    }

    public ContentCompressionExec(List<String> acceptEncoding, Lookup<UnaryOperator<HttpEntity>> decoderRegistry) {
        this(acceptEncoding, decoderRegistry, 5);
    }

    public ContentCompressionExec(int maxCodecListLen) {
        EnumMap<ContentCoding, UnaryOperator> decoderMap = new EnumMap<ContentCoding, UnaryOperator>(ContentCoding.class);
        for (ContentCoding c : ContentCoding.values()) {
            UnaryOperator<HttpEntity> d = ContentCodecRegistry.decoder(c);
            if (d == null) continue;
            decoderMap.put(c, d);
        }
        RegistryBuilder builder = RegistryBuilder.create();
        ArrayList<String> acceptList = new ArrayList<String>(decoderMap.size() + 1);
        decoderMap.forEach((coding, decoder) -> {
            acceptList.add(coding.token());
            builder.register(coding.token(), decoder);
        });
        if (decoderMap.containsKey((Object)ContentCoding.GZIP)) {
            acceptList.add(ContentCoding.X_GZIP.token());
            builder.register(ContentCoding.X_GZIP.token(), decoderMap.get((Object)ContentCoding.GZIP));
        }
        this.acceptEncoding = MessageSupport.headerOfTokens((String)"Accept-Encoding", acceptList);
        this.decoderRegistry = builder.build();
        this.maxCodecListLen = maxCodecListLen;
    }

    public ContentCompressionExec() {
        this(5);
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpClientContext clientContext = scope.clientContext;
        RequestConfig requestConfig = clientContext.getRequestConfigOrDefault();
        if (!request.containsHeader("Accept-Encoding") && requestConfig.isContentCompressionEnabled()) {
            request.addHeader(this.acceptEncoding);
        }
        ClassicHttpResponse response = chain.proceed(request, scope);
        HttpEntity entity = response.getEntity();
        if (requestConfig.isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L) {
            List<String> codecs = ContentCodingSupport.parseContentCodecs((EntityDetails)entity);
            ContentCodingSupport.validate(codecs, this.maxCodecListLen);
            if (!codecs.isEmpty()) {
                for (int i = codecs.size() - 1; i >= 0; --i) {
                    String codec = codecs.get(i);
                    UnaryOperator decoder = (UnaryOperator)this.decoderRegistry.lookup(codec);
                    if (decoder == null) {
                        throw new HttpException("Unsupported Content-Encoding: " + codec);
                    }
                    response.setEntity((HttpEntity)decoder.apply(response.getEntity()));
                }
            }
        }
        return response;
    }
}

