/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.hideshow;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.hideshow.IRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.HideRowByIndexCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowPositionHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllRowsCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlazedListsRowHideShowLayer<T>
extends AbstractLayerTransform
implements IRowHideShowLayer,
IUniqueIndexLayer {
    private static final Logger LOG = LoggerFactory.getLogger(GlazedListsRowHideShowLayer.class);
    public static final String PERSISTENCE_KEY_HIDDEN_ROW_IDS_COUNT = ".hiddenRowIDsCount";
    public static final String PERSISTENCE_KEY_HIDDEN_ROW_IDS = ".hiddenRowIDs";
    private final HashSet<Serializable> rowIdsToHide = new HashSet();
    private final IRowIdAccessor<T> rowIdAccessor;
    private final IRowDataProvider<T> rowDataProvider;
    private final HideRowMatcherEditor hideRowByIdMatcherEditor = new HideRowMatcherEditor();

    public GlazedListsRowHideShowLayer(ILayer underlyingLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor) {
        super(underlyingLayer);
        if (rowIdAccessor == null) {
            throw new IllegalArgumentException("rowIdAccessor can not be null!");
        }
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.registerCommandHandlers();
    }

    public GlazedListsRowHideShowLayer(ILayer underlyingLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor, FilterList<T> filterList) {
        super(underlyingLayer);
        if (rowIdAccessor == null) {
            throw new IllegalArgumentException("rowIdAccessor can not be null!");
        }
        if (filterList == null) {
            throw new IllegalArgumentException("filterList can not be null!");
        }
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        filterList.setMatcherEditor((MatcherEditor)this.hideRowByIdMatcherEditor);
        this.registerCommandHandlers();
    }

    public GlazedListsRowHideShowLayer(ILayer underlyingLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor, CompositeMatcherEditor<T> matcherEditor) {
        super(underlyingLayer);
        if (rowIdAccessor == null) {
            throw new IllegalArgumentException("rowIdAccessor can not be null!");
        }
        if (matcherEditor == null) {
            throw new IllegalArgumentException("matcherEditor can not be null!");
        }
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        matcherEditor.getMatcherEditors().add((Object)this.hideRowByIdMatcherEditor);
        this.registerCommandHandlers();
    }

    protected void registerCommandHandlers() {
        this.registerCommandHandler((ILayerCommandHandler)new RowHideCommandHandler((IRowHideShowLayer)this));
        this.registerCommandHandler((ILayerCommandHandler)new MultiRowHideCommandHandler((IRowHideShowLayer)this));
        this.registerCommandHandler((ILayerCommandHandler)new ShowAllRowsCommandHandler((IRowHideShowLayer)this));
        this.registerCommandHandler((ILayerCommandHandler)new MultiRowShowCommandHandler((IRowHideShowLayer)this));
        this.registerCommandHandler((ILayerCommandHandler)new RowPositionHideCommandHandler((IRowHideShowLayer)this));
        this.registerCommandHandler((ILayerCommandHandler)new HideRowByIndexCommandHandler((IRowHideShowLayer)this));
    }

    public MatcherEditor<T> getHideRowMatcherEditor() {
        return this.hideRowByIdMatcherEditor;
    }

    public void hideRowPositions(int ... rowPositions) {
        this.hideRows(Arrays.stream(rowPositions).map(arg_0 -> ((GlazedListsRowHideShowLayer)this).getRowIndexByPosition(arg_0)).mapToObj(rowIndex -> this.rowIdAccessor.getRowId(this.rowDataProvider.getRowObject(rowIndex))).collect(Collectors.toSet()));
    }

    public void hideRowPositions(Collection<Integer> rowPositions) {
        this.hideRowPositions(rowPositions.stream().mapToInt(Integer::intValue).toArray());
    }

    public void hideRowIndexes(int ... rowIndexes) {
        this.hideRows(Arrays.stream(rowIndexes).mapToObj(rowIndex -> this.rowIdAccessor.getRowId(this.rowDataProvider.getRowObject(rowIndex))).collect(Collectors.toSet()));
    }

    public void hideRowIndexes(Collection<Integer> rowIndexes) {
        this.hideRowPositions(rowIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    public void showRowIndexes(int ... rowIndexes) {
        this.showRows(Arrays.stream(rowIndexes).mapToObj(rowIndex -> this.rowIdAccessor.getRowId(this.rowDataProvider.getRowObject(rowIndex))).collect(Collectors.toSet()));
    }

    public void showRowIndexes(Collection<Integer> rowIndexes) {
        this.showRowIndexes(rowIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    public void hideRows(Collection<Serializable> rowIds) {
        this.rowIdsToHide.addAll(rowIds);
        this.hideRowByIdMatcherEditor.fireChange();
    }

    public void showRows(Collection<Serializable> rowIds) {
        this.rowIdsToHide.removeAll(rowIds);
        this.hideRowByIdMatcherEditor.fireChange();
    }

    public void showRowPosition(int rowPosition, boolean showToTop, boolean showAll) {
        throw new UnsupportedOperationException("Hidden rows are filtered from the content and therefore not next to any other row position");
    }

    public void showAllRows() {
        this.rowIdsToHide.clear();
        this.hideRowByIdMatcherEditor.fireChange();
    }

    public MatcherEditor<T> getMatcherEditor() {
        return this.hideRowByIdMatcherEditor;
    }

    public int getColumnPositionByIndex(int columnIndex) {
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getColumnPositionByIndex(columnIndex);
    }

    public int getRowPositionByIndex(int rowIndex) {
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getRowPositionByIndex(rowIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveState(String prefix, Properties properties) {
        block18: {
            if (!this.rowIdsToHide.isEmpty()) {
                properties.setProperty(prefix + PERSISTENCE_KEY_HIDDEN_ROW_IDS_COUNT, Integer.toString(this.rowIdsToHide.size()));
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        try {
                            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                                Iterator<Serializable> iterator = this.rowIdsToHide.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        properties.setProperty(prefix + PERSISTENCE_KEY_HIDDEN_ROW_IDS, new String(Base64.encodeBase64((byte[])bos.toByteArray())));
                                        break;
                                    }
                                    Serializable serializable = iterator.next();
                                    out.writeObject(serializable);
                                }
                            }
                            if (bos == null) break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (bos == null) throw throwable;
                            bos.close();
                            throw throwable;
                        }
                        bos.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOG.error("Error while persisting GlazedListsRowHideShowLayer state", (Throwable)e);
                }
            }
        }
        super.saveState(prefix, properties);
    }

    public void loadState(String prefix, Properties properties) {
        this.rowIdsToHide.clear();
        String property = properties.getProperty(prefix + PERSISTENCE_KEY_HIDDEN_ROW_IDS_COUNT);
        int count = property != null ? Integer.valueOf(property) : 0;
        property = properties.getProperty(prefix + PERSISTENCE_KEY_HIDDEN_ROW_IDS);
        if (property != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(Base64.decodeBase64((byte[])property.getBytes())));){
                    Serializable ser = null;
                    int i = 0;
                    while (i < count) {
                        ser = (Serializable)in.readObject();
                        this.rowIdsToHide.add(ser);
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOG.error("Error while restoring GlazedListsRowHideShowLayer state", (Throwable)e);
            }
        }
        this.hideRowByIdMatcherEditor.fireChange();
        super.loadState(prefix, properties);
    }

    class HideRowMatcherEditor
    extends AbstractMatcherEditor<T> {
        private final Matcher<T> hideRowByIdMatcher = rowObject -> !GlazedListsRowHideShowLayer.this.rowIdsToHide.contains(GlazedListsRowHideShowLayer.this.rowIdAccessor.getRowId(rowObject));

        HideRowMatcherEditor() {
        }

        public void fireChange() {
            this.fireChanged(this.hideRowByIdMatcher);
        }
    }
}

