/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.launching;

import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.m2m.atl.adt.launching.AtlVM;

public class AtlLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String atlVMName = configuration.getAttribute("ATL VM", "");
        AtlVM atlVM = AtlVM.getVM(atlVMName);
        boolean printExecutionTime = launch.getLaunchConfiguration().getAttribute("printExecutionTime", false);
        long startTime = System.currentTimeMillis();
        atlVM.launch(configuration, mode, launch, monitor);
        long endTime = System.currentTimeMillis();
        if (printExecutionTime && !mode.equals("debug")) {
            logger.info(String.valueOf(launch.getLaunchConfiguration().getAttribute("ATL File Name", "Transformation")) + " executed in " + (double)(endTime - startTime) / 1000.0 + " s (including model loading and saving).");
        }
    }
}

