/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.nattable.documentstructuretemplate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ImportMethod implements Enumerator
{
    IMAGE(0, "IMAGE", "IMAGE"),
    TABLE(1, "TABLE", "TABLE");

    public static final int IMAGE_VALUE = 0;
    public static final int TABLE_VALUE = 1;
    private static final ImportMethod[] VALUES_ARRAY;
    public static final List<ImportMethod> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ImportMethod[]{IMAGE, TABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ImportMethod get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImportMethod result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImportMethod getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImportMethod result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImportMethod get(int value) {
        switch (value) {
            case 0: {
                return IMAGE;
            }
            case 1: {
                return TABLE;
            }
        }
        return null;
    }

    private ImportMethod(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

