/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.internal.custom;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.RepresentationPackage;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.command.ICreateDocumentTemplateEditorCommand;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.impl.PapyrusDocumentPrototypeImpl;

public class CustomPapyrusDocumentPrototypeImpl
extends PapyrusDocumentPrototypeImpl {
    private static final String REQUIRED_ELEMENT_TYPE_NAME = "DocumentTemplateContext";
    private static final String REQUIRED_ELEMENT_TYPE_IDENTIFIER = "org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.types.elementTypeSet";

    @Override
    public boolean isValidClass(DiagnosticChain chain, Map<Object, Object> context) {
        String creationClassName = this.getCreationCommandClass();
        Class creationClass = ClassLoaderHelper.loadClass((String)creationClassName);
        Object newInstance = null;
        if (creationClass != null) {
            try {
                Constructor constructor = creationClass.getDeclaredConstructor(new Class[0]);
                newInstance = constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException | SecurityException constructor) {
            }
            catch (InstantiationException constructor) {
            }
            catch (IllegalAccessException constructor) {
            }
            catch (IllegalArgumentException constructor) {
            }
            catch (InvocationTargetException constructor) {
                // empty catch block
            }
        }
        if (newInstance == null) {
            if (chain != null) {
                chain.add(this.createDiagnostic(NLS.bind((String)"The referenced creationClassCommand {0} can't be instanciated", (Object)creationClass.getCanonicalName())));
            }
        } else if (!ICreateDocumentTemplateEditorCommand.class.isInstance(newInstance)) {
            chain.add(this.createDiagnostic(NLS.bind((String)"The class {0} is not an instance of {1}.", (Object)newInstance.getClass().getCanonicalName(), (Object)ICreateDocumentTemplateEditorCommand.class.getCanonicalName())));
        }
        ArchitectureDescriptionLanguage language = this.getLanguage();
        boolean contains = false;
        Iterator iter = language.getElementTypes().iterator();
        while (iter.hasNext() && !contains) {
            ElementTypeSetConfiguration type = (ElementTypeSetConfiguration)iter.next();
            boolean bl = contains = REQUIRED_ELEMENT_TYPE_IDENTIFIER.equals(type.getIdentifier()) && REQUIRED_ELEMENT_TYPE_NAME.equals(type.getName());
        }
        if (!contains) {
            chain.add(this.createDiagnostic(NLS.bind((String)"The element type {0} is not registered in your architecture file.", (Object)REQUIRED_ELEMENT_TYPE_IDENTIFIER)));
        }
        return super.isValidClass(chain, context);
    }

    private Diagnostic createDiagnostic(String message) {
        return new BasicDiagnostic(4, "org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation", 1, message, new Object[]{this, RepresentationPackage.eINSTANCE.getPapyrusDocumentPrototype_CreationCommandClass()});
    }
}

