/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.dev.tools.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.dev.tools.Activator;
import org.eclipse.papyrus.model2doc.dev.tools.handlers.AbstractZipFileHandler;

public class ExtractContentsXmlFileHandler
extends AbstractZipFileHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (URI uri : this.getSelectedFileURI()) {
            String contentXMLLocation = ExtractContentsXmlFileHandler.getOSPathFromURI(uri.trimFileExtension().appendFileExtension("xml"));
            String odtFileLocation = ExtractContentsXmlFileHandler.getOSPathFromURI(uri);
            File odtFile = new File(odtFileLocation);
            try {
                ZipFile odtZipFile = new ZipFile(odtFile);
                Enumeration<? extends ZipEntry> entries = odtZipFile.entries();
                FileOutputStream outputStream = new FileOutputStream(contentXMLLocation);
                while (entries.hasMoreElements()) {
                    ZipEntry current = entries.nextElement();
                    if (!"content.xml".equals(current.getName())) continue;
                    InputStream in = odtZipFile.getInputStream(current);
                    while (in.available() > 0) {
                        int read = in.read();
                        outputStream.write(read);
                    }
                    in.close();
                    break;
                }
                odtZipFile.close();
                outputStream.close();
                Activator.log.info(NLS.bind((String)"XML file extracted from {0}", (Object)uri.toString()));
            }
            catch (FileNotFoundException e) {
                Activator.log.error(NLS.bind((String)"XML file not found in {0}", (Object)uri.toString()), (Throwable)e);
            }
            catch (IOException e) {
                Activator.log.error(NLS.bind((String)"IOException extracting XML file from {0}", (Object)uri.toString()), (Throwable)e);
            }
            ExtractContentsXmlFileHandler.refreshWorkspace();
            ExtractContentsXmlFileHandler.formatXMLFile(contentXMLLocation);
        }
        return null;
    }

    @Override
    protected String getTemplateExtension() {
        return "ott";
    }

    @Override
    protected String getFileExtension() {
        return "odt";
    }
}

