/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui.dnd;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class DiagramNodeCreator {
    protected Point firstNodeLocation;
    protected GraphicalEditPart parentViewEditPart;
    protected View parentView;

    public DiagramNodeCreator(View parentView, GraphicalEditPart parentViewEditPart, Point firstNodeLocation) {
        this.parentView = parentView;
        this.parentViewEditPart = parentViewEditPart;
        this.firstNodeLocation = firstNodeLocation;
    }

    protected Point getFirstNodeLocation() {
        return this.firstNodeLocation;
    }

    protected GraphicalEditPart getParentViewEditPart() {
        return this.parentViewEditPart;
    }

    protected View getParentView() {
        return this.parentView;
    }

    public void createNodesFor(IProgressMonitor monitor, List<NamedElement> returnedReversedNamedElement) {
        if (returnedReversedNamedElement == null) {
            return;
        }
        Point nextLocation = this.getFirstNodeLocation();
        for (NamedElement namedElement : returnedReversedNamedElement) {
            if (this.isViewExistFor(this.getParentView(), namedElement)) continue;
            View view = null;
            if (namedElement instanceof Class) {
                view = this.createViewForClass(this.getParentViewEditPart(), this.getParentView(), (Class)namedElement);
            } else if (namedElement instanceof Package) {
                view = this.createViewForNamedElement(this.getParentViewEditPart(), this.getParentView(), (NamedElement)((Package)namedElement));
            } else if (namedElement instanceof NamedElement) {
                view = this.createViewForNamedElement(this.getParentViewEditPart(), this.getParentView(), namedElement);
            }
            if (view == null) continue;
            this.setViewBounds(view, nextLocation);
            nextLocation = nextLocation.getTranslated(20, 20);
        }
    }

    private View createViewForNamedElement(GraphicalEditPart parentViewEditPart, View parentView, NamedElement namedElement) {
        IHintedType elementType = (IHintedType)UMLElementTypes.getElementType((String)UMLVisualIDRegistry.getNodeVisualID((View)this.getParentView(), (EObject)namedElement));
        Node view = ViewService.createNode((View)parentView, (EObject)namedElement, (String)elementType.getSemanticHint(), (PreferencesHint)parentViewEditPart.getDiagramPreferencesHint());
        return view;
    }

    private View createViewForClass(GraphicalEditPart parentViewEditPart, View parentView, Class namedElement) {
        IHintedType elementType = (IHintedType)UMLElementTypes.getElementType((String)UMLVisualIDRegistry.getNodeVisualID((View)this.getParentView(), (EObject)namedElement));
        Node view = ViewService.createNode((View)parentView, (EObject)namedElement, (String)elementType.getSemanticHint(), (PreferencesHint)parentViewEditPart.getDiagramPreferencesHint());
        return view;
    }

    private void setViewBounds(View view, Point location) {
        if (location != null) {
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)location.x);
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)location.y);
        }
    }

    private boolean isViewExistFor(View targetView, NamedElement createdClass) {
        for (Object ele : targetView.getChildren()) {
            if (((View)ele).getElement() != createdClass) continue;
            return true;
        }
        return false;
    }
}

