/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.ExternLibrary;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.External;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

public class JavaGenUtils {
    public static final String JAVA_LANG = "java.lang.";
    private static NamedElement currentNE;
    public static Map<NamedElement, EList<String>> imports;

    public static void resetImports() {
        imports = new HashMap<NamedElement, EList<String>>();
    }

    public static String getStdtypes(PrimitiveType type) {
        Element owner = type.getOwner();
        String owningPkgName = "";
        if (owner instanceof Package) {
            owningPkgName = ((Package)owner).getName();
        }
        if (owningPkgName.equals("PrimitiveTypes") || owningPkgName.equals("UMLPrimitiveTypes") || owningPkgName.equals("MARTE_PrimitivesTypes")) {
            String td = "";
            String name = type.getName();
            td = name.equalsIgnoreCase("Integer") ? "int" : (name.equalsIgnoreCase("Unlimited Natural") ? "long" : (name.equalsIgnoreCase("Real") ? "float" : (name.equalsIgnoreCase("String") ? "String" : name.toLowerCase())));
            return td;
        }
        return null;
    }

    public static String javaQualifiedName(NamedElement ne) {
        External ext;
        if (ne == null) {
            return "undefined";
        }
        if (GenUtils.hasStereotypeTree((Element)ne, NoCodeGen.class)) {
            return ne.getName();
        }
        if (ne instanceof PrimitiveType) {
            String stdType = JavaGenUtils.getStdtypes((PrimitiveType)ne);
            if (stdType != null) {
                return stdType;
            }
            return ne.getName();
        }
        if (ne.getOwner() instanceof ClassifierTemplateParameter) {
            return ne.getName();
        }
        if (ne instanceof Classifier && !((Classifier)ne).getTemplateBindings().isEmpty()) {
            TemplateBinding templateBinding = (TemplateBinding)((Classifier)ne).getTemplateBindings().get(0);
            TemplateSignature signature = templateBinding.getSignature();
            String specializedTypeName = "";
            if (signature != null && signature.getTemplate() instanceof Classifier) {
                specializedTypeName = JavaGenUtils.javaQualifiedName((NamedElement)((Classifier)signature.getTemplate()), (Element)ne);
                EList templateParameters = signature.getOwnedParameters();
                HashMap<TemplateParameter, NamedElement> parameterToClassMap = new HashMap<TemplateParameter, NamedElement>();
                EList substitutions = templateBinding.getParameterSubstitutions();
                for (TemplateParameterSubstitution substitution : substitutions) {
                    if (substitution.getFormal() == null || !templateParameters.contains(substitution.getFormal()) || !(substitution.getActual() instanceof NamedElement)) continue;
                    parameterToClassMap.put(substitution.getFormal(), (NamedElement)substitution.getActual());
                }
                if (parameterToClassMap.size() == templateParameters.size()) {
                    specializedTypeName = String.valueOf(specializedTypeName) + "<";
                    for (TemplateParameter templateParameter : templateParameters) {
                        NamedElement substitutionType = (NamedElement)parameterToClassMap.get(templateParameter);
                        specializedTypeName = String.valueOf(specializedTypeName) + JavaGenUtils.javaQualifiedName(substitutionType, (Element)ne) + ", ";
                    }
                    specializedTypeName = specializedTypeName.substring(0, specializedTypeName.length() - 2);
                    specializedTypeName = String.valueOf(specializedTypeName) + ">";
                }
                return specializedTypeName;
            }
        }
        String qName = GenUtils.getFullName((NamedElement)ne, (String)".", (boolean)false);
        ExternLibrary el = (ExternLibrary)GenUtils.getApplicationTree((Element)ne, ExternLibrary.class);
        if (el != null && el.getPrefix() != null) {
            qName = String.valueOf(el.getPrefix()) + "." + ne.getName();
        }
        if ((ext = (External)UMLUtil.getStereotypeApplication((Element)ne, External.class)) != null && ext.getName() != null) {
            qName = ext.getName();
        }
        return qName;
    }

    public static String javaQualifiedName(NamedElement ne, Element context) {
        String qName = JavaGenUtils.javaQualifiedName(ne);
        if (context instanceof Classifier) {
            for (Element directlyOwnedElement : context.getOwnedElements()) {
                if (!(directlyOwnedElement instanceof Enumeration) && !(directlyOwnedElement instanceof Interface) && !directlyOwnedElement.eClass().equals(UMLFactory.eINSTANCE.getUMLPackage().getClass_())) continue;
                if (((Classifier)directlyOwnedElement).getQualifiedName().equals(ne.getQualifiedName())) {
                    return ne.getName();
                }
                if (!((Classifier)directlyOwnedElement).getName().equals(ne.getName())) continue;
                return qName;
            }
        }
        if (ne.getOwner() == context.getOwner() || JavaGenUtils.isJavaLang(qName)) {
            return ne.getName();
        }
        EList<String> importsOfCurrentNs = imports.get(currentNE);
        if (importsOfCurrentNs != null) {
            for (String importOfCurrentNs : importsOfCurrentNs) {
                if (!importOfCurrentNs.equals(qName)) continue;
                return ne.getName();
            }
        }
        return qName;
    }

    public static boolean isJavaLang(String qName) {
        return qName.startsWith(JAVA_LANG) && qName.indexOf(".", JAVA_LANG.length()) == -1;
    }

    public static String getTemplateTypeName(TemplateParameter templateParam) {
        String name = "";
        ParameterableElement pElt = templateParam.getParameteredElement();
        name = pElt != null && pElt instanceof NamedElement ? ((NamedElement)pElt).getName() : "undefined";
        return name;
    }

    public static String getNamespace(NamedElement ne) {
        String namespace = "";
        for (Namespace ns : ne.allNamespaces()) {
            if (ns.getOwner() == null) continue;
            String nsName = ns.getName();
            if (!namespace.equals("")) {
                nsName = String.valueOf(nsName) + "::";
            }
            namespace = String.valueOf(nsName) + namespace;
        }
        if (!namespace.equals("")) {
            namespace = "\nusing namespace " + namespace + ";\n";
        }
        return namespace;
    }

    public static void openNS(NamedElement ne) {
        currentNE = ne;
    }
}

