/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.browser.QueryBrowserPopup;
import org.eclipse.mat.ui.internal.browser.QueryBrowserProvider;
import org.eclipse.mat.ui.internal.browser.QueryHistory;
import org.eclipse.mat.ui.util.IPolicy;

public class QueryHistoryProvider
extends QueryBrowserProvider {
    IQueryContext context;
    IPolicy policy;

    public QueryHistoryProvider(IQueryContext context, IPolicy policy) {
        this.context = context;
        this.policy = policy;
    }

    @Override
    public QueryBrowserPopup.Element[] getElements() {
        List<String> history = QueryHistory.getHistoryEntries();
        ArrayList<HQQElement> answer = new ArrayList<HQQElement>(history.size());
        for (String entry : history) {
            HQQElement element = new HQQElement(entry);
            QueryDescriptor query = element.getQuery();
            if (query == null || !query.accept(this.context) || !this.policy.accept(query) || QueryHistoryProvider.unsuitableSubjects(query, this.context)) continue;
            answer.add(element);
        }
        return answer.toArray(new QueryBrowserPopup.Element[0]);
    }

    @Override
    public String getName() {
        return Messages.QueryHistoryProvider_History;
    }

    @Override
    public QueryBrowserPopup.Element[] getElementsSorted() {
        if (this.sortedElements == null) {
            this.sortedElements = this.getElements();
        }
        return this.sortedElements;
    }

    static class HQQElement
    implements QueryBrowserPopup.Element {
        QueryDescriptor query;
        String commandLine;

        public HQQElement(String commandLine) {
            this.commandLine = commandLine;
            int p = commandLine.indexOf(32);
            String name = p < 0 ? commandLine : commandLine.substring(0, p);
            this.query = QueryRegistry.instance().getQuery(name);
        }

        @Override
        public String getLabel() {
            return this.commandLine;
        }

        @Override
        public String getUsage() {
            return this.commandLine;
        }

        @Override
        public QueryDescriptor getQuery() {
            return this.query;
        }

        @Override
        public void execute(MultiPaneEditor editor) throws SnapshotException {
            QueryExecution.executeCommandLine(editor, null, this.commandLine);
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            if (this.query != null && this.query.getIcon() != null) {
                return MemoryAnalyserPlugin.getDefault().getImageDescriptor(this.query);
            }
            return null;
        }
    }
}

