/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class DocumentDidOpenTest
extends AbstractTestWithProject {
    @Test
    public void testOpen() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        CompletableFuture didOpenExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidOpenCallback(didOpenExpectation);
        TestUtils.openEditor(testFile);
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assertions.assertNotNull((Object)document);
        LanguageServers.forDocument((IDocument)document).anyMatching();
        DidOpenTextDocumentParams lastOpen = (DidOpenTextDocumentParams)didOpenExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)lastOpen.getTextDocument());
        Assertions.assertEquals((Object)"lspt", (Object)lastOpen.getTextDocument().getLanguageId());
    }

    @Test
    public void testOpenExternalFile(@TempDir Path tempDir) throws Exception {
        Path file = Files.createFile(tempDir.resolve("testOpenExternalFile.lspt"), new FileAttribute[0]);
        CompletableFuture didOpenExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidOpenCallback(didOpenExpectation);
        IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toUri()));
        LanguageServers.forDocument((IDocument)LSPEclipseUtils.getDocument((IEditorInput)editor.getEditorInput())).anyMatching();
        DidOpenTextDocumentParams lastOpen = (DidOpenTextDocumentParams)didOpenExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)lastOpen.getTextDocument());
        Assertions.assertEquals((Object)"lspt", (Object)lastOpen.getTextDocument().getLanguageId());
    }

    @Test
    public void testOpenWithSpecificLanguageId() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lspt-different", "");
        CompletableFuture didOpenExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidOpenCallback(didOpenExpectation);
        IEditorPart editor = TestUtils.openEditor(testFile);
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assertions.assertNotNull((Object)document);
        LanguageServers.forDocument((IDocument)document).anyMatching();
        DidOpenTextDocumentParams lastOpen = (DidOpenTextDocumentParams)didOpenExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)lastOpen.getTextDocument());
        Assertions.assertEquals((Object)"differentLanguageId", (Object)lastOpen.getTextDocument().getLanguageId());
        ((AbstractTextEditor)editor).close(false);
    }
}

