/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractCompletionTest
extends AbstractTestWithProject {
    protected LSContentAssistProcessor contentAssistProcessor;

    @Before
    public void setUp() {
        this.contentAssistProcessor = new LSContentAssistProcessor(true, false);
    }

    protected CompletionItem createCompletionItem(String label, CompletionItemKind kind) {
        return this.createCompletionItem(label, kind, new Range(new Position(0, 0), new Position(0, label.length())));
    }

    protected CompletionItem createCompletionItem(String label, CompletionItemKind kind, Range range) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setKind(kind);
        item.setTextEdit(Either.forLeft((Object)new TextEdit(range, label)));
        return item;
    }

    protected CompletionItem createCompletionItemWithInsertReplace(String label, CompletionItemKind kind, Range insertRange, Range replaceRange) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setKind(kind);
        InsertReplaceEdit insertReplaceEdit = new InsertReplaceEdit();
        insertReplaceEdit.setNewText(label);
        insertReplaceEdit.setInsert(insertRange);
        insertReplaceEdit.setReplace(replaceRange);
        item.setTextEdit(Either.forRight((Object)insertReplaceEdit));
        return item;
    }

    protected void confirmCompletionResults(String[] completions, String content, Integer cursorIndexInContent, String[] expectedOrder) throws CoreException {
        Range range = new Range(new Position(0, 0), new Position(0, cursorIndexInContent.intValue()));
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        String[] stringArray = completions;
        int n = completions.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            items.add(this.createCompletionItem(string, CompletionItemKind.Class, range));
            ++n2;
        }
        this.confirmCompletionResults(items, content, cursorIndexInContent, expectedOrder);
    }

    protected void confirmCompletionResults(List<CompletionItem> completions, String content, Integer cursorIndexInContent, String[] expectedOrder) throws CoreException {
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, completions));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, cursorIndexInContent.intValue());
        Assert.assertEquals((long)expectedOrder.length, (long)proposals.length);
        int i = 0;
        while (i < proposals.length) {
            Assert.assertEquals((Object)expectedOrder[i], (Object)proposals[i].getDisplayString());
            ++i;
        }
    }
}

