/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.conformance.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.lsat.common.emf.ui.wizards.ElementTreeSelectionWizardPage;
import org.eclipse.lsat.conformance.ui.ConformanceCheckOptions;
import org.eclipse.lsat.conformance.ui.ConformanceCheckOptionsPage;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConformanceCheckWizard
extends Wizard {
    private static final IContentType TRACE_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.lsat.common.trace");
    private final ConformanceCheckOptions options;
    private final ElementTreeSelectionWizardPage traceFileSelectionPage;
    private final ConformanceCheckOptionsPage conformancePropertiesPage;

    public ConformanceCheckWizard(ConformanceCheckOptions options) {
        this.options = options;
        this.traceFileSelectionPage = this.createTraceFileSelectionPage();
        this.conformancePropertiesPage = new ConformanceCheckOptionsPage(options);
        this.setWindowTitle("Run Conformance Check");
        this.setDefaultPageImageDescriptor(ResourceLocator.imageDescriptorFromBundle(ConformanceCheckWizard.class, (String)"icons/run_wiz.png").orElse(null));
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.traceFileSelectionPage);
        this.addPage((IWizardPage)this.conformancePropertiesPage);
    }

    public boolean performFinish() {
        Object[] objectArray = this.traceFileSelectionPage.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object traceFile = objectArray[n2];
            if (traceFile instanceof IFile) {
                this.options.addTraceFile((IFile)traceFile);
            }
            ++n2;
        }
        return true;
    }

    private ElementTreeSelectionWizardPage createTraceFileSelectionPage() {
        ElementTreeSelectionWizardPage traceFileSelectionPage = new ElementTreeSelectionWizardPage("TraceFileSelectionPage", (IBaseLabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        traceFileSelectionPage.setTitle("Select traces");
        traceFileSelectionPage.setMessage("Select throughput traces to check against the specification");
        traceFileSelectionPage.setInput((Object)this.options.getWorkspace());
        traceFileSelectionPage.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return ConformanceCheckWizard.this.isTraceFile((IFile)element);
                }
                return element instanceof IContainer;
            }
        });
        traceFileSelectionPage.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0) {
                    return new Status(4, "org.eclipse.lsat.conformance.ui", 0, "Please select a trace!", null);
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (!(selected instanceof IFile)) {
                        return new Status(4, "org.eclipse.lsat.conformance.ui", 0, "Please select trace files only!", null);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        });
        try {
            final String traceFileName = this.options.getModelFile().getFullPath().removeFileExtension().addFileExtension("trace").lastSegment();
            final ArrayList selections = new ArrayList();
            this.options.getModelFile().getParent().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getName().startsWith(traceFileName)) {
                        selections.add(resource);
                    }
                    return true;
                }
            });
            traceFileSelectionPage.setInitialSelections(selections);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return traceFileSelectionPage;
    }

    private boolean isTraceFile(IFile file) {
        IContentDescription contentDescription;
        block3: {
            try {
                contentDescription = file.getContentDescription();
                if (contentDescription != null) break block3;
                return false;
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "org.eclipse.lsat.conformance.ui");
                return false;
            }
        }
        IContentType contentType = contentDescription.getContentType();
        return contentType != null && contentType.isKindOf(TRACE_CONTENT_TYPE);
    }
}

