/**
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.machine.teditor.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.lsat.machine.teditor.MachineRuntimeModule;
import org.eclipse.lsat.machine.teditor.MachineStandaloneSetup;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class MachineIdeSetup extends MachineStandaloneSetup {
  @Override
  public Injector createInjector() {
    MachineRuntimeModule _machineRuntimeModule = new MachineRuntimeModule();
    MachineIdeModule _machineIdeModule = new MachineIdeModule();
    return Guice.createInjector(Modules2.mixin(_machineRuntimeModule, _machineIdeModule));
  }
}
