/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.datastructures.tuple;

import java.util.Objects;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Quadruple;

public final class ImmutableQuadruple<L, ML, MR, R>
extends Quadruple<L, ML, MR, R> {
    public final L left;
    public final ML middleLeft;
    public final MR middleRight;
    public final R right;

    public static <L, ML, MR, R> ImmutableQuadruple<L, ML, MR, R> of(L left, ML middleLeft, MR middleRight, R right) {
        return new ImmutableQuadruple<L, ML, MR, R>(left, middleLeft, middleRight, right);
    }

    public ImmutableQuadruple(L left, ML middleLeft, MR middleRight, R right) {
        this.left = left;
        this.middleLeft = middleLeft;
        this.middleRight = middleRight;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public ML getMiddleLeft() {
        return this.middleLeft;
    }

    @Override
    public MR getMiddleRight() {
        return this.middleRight;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.left);
        hash = 97 * hash + Objects.hashCode(this.middleLeft);
        hash = 97 * hash + Objects.hashCode(this.middleRight);
        hash = 97 * hash + Objects.hashCode(this.right);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableQuadruple other = (ImmutableQuadruple)obj;
        if (!Objects.equals(this.left, other.left)) {
            return false;
        }
        if (!Objects.equals(this.middleLeft, other.middleLeft)) {
            return false;
        }
        if (!Objects.equals(this.middleRight, other.middleRight)) {
            return false;
        }
        return Objects.equals(this.right, other.right);
    }
}

