/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.datastructures.tuple;

import java.util.Objects;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;

public final class ImmutableTuple<L, R>
extends Tuple<L, R> {
    public final L left;
    public final R right;

    public static <L, R> ImmutableTuple<L, R> of(L left, R right) {
        return new ImmutableTuple<L, R>(left, right);
    }

    public ImmutableTuple(L left, R right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.left);
        hash = 61 * hash + Objects.hashCode(this.right);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableTuple other = (ImmutableTuple)obj;
        if (!Objects.equals(this.left, other.left)) {
            return false;
        }
        return Objects.equals(this.right, other.right);
    }
}

