/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.eclipse.lsat.common.util.BranchIterator;
import org.eclipse.lsat.common.util.IteratorUtil;
import org.eclipse.lsat.common.util.StackedIterator;

public class TreeWalkerIterator<E>
implements BranchIterator<E> {
    private final Function<E, Iterator<? extends E>> childrenFunctor;
    private final StackedIterator<E> stackedIterator;
    private boolean canPrune = false;

    public TreeWalkerIterator(Iterator<? extends E> source, boolean includeSource, Function<E, Iterator<? extends E>> childrenFunctor) {
        this.childrenFunctor = childrenFunctor;
        this.stackedIterator = includeSource ? new StackedIterator<E>(source) : new StackedIterator<E>(IteratorUtil.flatMap(source, childrenFunctor));
    }

    @Override
    public boolean hasNext() {
        this.canPrune = false;
        return this.stackedIterator.hasNext();
    }

    @Override
    public E next() {
        E next = this.stackedIterator.next();
        Iterator<? extends E> children = this.childrenFunctor.apply(next);
        this.stackedIterator.push(children == null ? Collections.emptyIterator() : children);
        this.canPrune = true;
        return next;
    }

    @Override
    public void prune() {
        if (!this.canPrune) {
            throw new IllegalStateException("Prune is not allowed");
        }
        this.stackedIterator.pop();
        this.canPrune = false;
    }
}

