/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.xerces.xerces.xpointer;

import java.io.PrintWriter;
import org.codelibs.xerces.xerces.xni.XNIException;
import org.codelibs.xerces.xerces.xni.parser.XMLErrorHandler;
import org.codelibs.xerces.xerces.xni.parser.XMLParseException;

final class XPointerErrorHandler
implements XMLErrorHandler {
    protected PrintWriter fOut;

    public XPointerErrorHandler() {
        this(new PrintWriter(System.err));
    }

    public XPointerErrorHandler(PrintWriter printWriter) {
        this.fOut = printWriter;
    }

    @Override
    public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Warning", xMLParseException);
    }

    @Override
    public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Error", xMLParseException);
    }

    @Override
    public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Fatal Error", xMLParseException);
        throw xMLParseException;
    }

    private void printError(String string, XMLParseException xMLParseException) {
        this.fOut.print("[");
        this.fOut.print(string);
        this.fOut.print("] ");
        String string2 = xMLParseException.getExpandedSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            this.fOut.print(string2);
        }
        this.fOut.print(':');
        this.fOut.print(xMLParseException.getLineNumber());
        this.fOut.print(':');
        this.fOut.print(xMLParseException.getColumnNumber());
        this.fOut.print(": ");
        this.fOut.print(xMLParseException.getMessage());
        this.fOut.println();
        this.fOut.flush();
    }
}

