/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.linuxtools.internal.docker.ui.MinimizedFileSystemElement;
import org.eclipse.linuxtools.internal.docker.ui.SelectFilesOperation;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class PopulateRootOperation
extends SelectFilesOperation {
    public PopulateRootOperation(Object rootObject, IImportStructureProvider structureProvider) {
        super(rootObject, structureProvider);
    }

    @Override
    protected FileSystemElement createElement(FileSystemElement parent, Object fileSystemObject) throws InterruptedException {
        return this.createElement(parent, fileSystemObject, 2);
    }

    protected FileSystemElement createElement(FileSystemElement parent, Object fileSystemObject, int depth) throws InterruptedException {
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        boolean isContainer = this.provider.isFolder(fileSystemObject);
        String elementLabel = parent == null ? this.provider.getFullPath(fileSystemObject) : this.provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, parent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        if (isContainer && depth > 0) {
            List children = this.provider.getChildren(fileSystemObject);
            if (children != null) {
                Iterator childrenEnum = children.iterator();
                while (childrenEnum.hasNext()) {
                    this.createElement(result, childrenEnum.next(), depth - 1);
                }
            }
            result.setPopulated();
        }
        return result;
    }
}

