/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapView;
import org.eclipse.linuxtools.internal.callgraph.core.ViewFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SystemTapTextView
extends SystemTapView {
    private StyledText viewer;
    private Display display;
    private int previousEnd;

    public void setFocus() {
        if (this.viewer != null && !this.viewer.isDisposed()) {
            this.viewer.setFocus();
        }
    }

    private void createViewer(Composite parent) {
        this.viewer = new StyledText(parent, 586);
        this.viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        Font font = new Font((Device)parent.getDisplay(), "Monospace", 11, 0);
        this.viewer.setFont(font);
        this.masterComposite = parent;
        this.display = this.masterComposite.getDisplay();
    }

    private void prettyPrintln(String text) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        String[] txt = text.split("\\n");
        int lineOffset = 0;
        for (String line : txt) {
            if (line.isEmpty()) {
                this.viewer.append("\n");
                continue;
            }
            String[] split_txt = line.split("~\\(");
            if (split_txt.length == 1) {
                this.viewer.append(split_txt[0]);
                this.viewer.append("\n");
                continue;
            }
            int inLineOffset = 0;
            for (String split : split_txt) {
                if (split.isEmpty()) continue;
                String[] coloursAndText = split.split("\\)~");
                if (coloursAndText.length != 2) {
                    for (String colourAndText : coloursAndText) {
                        this.viewer.append(colourAndText);
                        inLineOffset += colourAndText.length();
                    }
                    continue;
                }
                String[] colours = coloursAndText[0].split(",");
                if (colours.length < 3) continue;
                this.viewer.append(coloursAndText[1]);
                int R = Integer.valueOf(colours[0].replaceAll(" ", ""));
                int G = Integer.valueOf(colours[1].replaceAll(" ", ""));
                int B = Integer.valueOf(colours[2].replaceAll(" ", ""));
                if (R > 255) {
                    R = 255;
                }
                if (G > 255) {
                    G = 255;
                }
                if (B > 255) {
                    B = 255;
                }
                if (R < 0) {
                    R = 0;
                }
                if (G < 0) {
                    G = 0;
                }
                if (B < 0) {
                    B = 0;
                }
                Color newColor = new Color((Device)this.display, R, G, B);
                lineOffset = this.viewer.getOffsetAtLine(this.viewer.getLineCount() - 1);
                StyleRange newStyle = new StyleRange(lineOffset + inLineOffset, coloursAndText[1].length(), newColor, null);
                styles.add(newStyle);
                inLineOffset += coloursAndText[1].length();
            }
            this.viewer.append("\n");
        }
        StyleRange[] s = new StyleRange[styles.size()];
        styles.toArray(s);
        int cnt = this.viewer.getCharCount();
        this.viewer.replaceStyleRanges(this.previousEnd, cnt - this.previousEnd, s);
        this.previousEnd = cnt;
        this.viewer.setTopIndex(this.viewer.getLineCount() - 1);
        this.viewer.update();
    }

    public void println(String text) {
        if (this.viewer != null && !this.viewer.isDisposed()) {
            this.viewer.append(text);
            this.viewer.setTopIndex(this.viewer.getLineCount() - 1);
            this.viewer.update();
        }
    }

    public void clearAll() {
        if (this.viewer != null && !this.viewer.isDisposed()) {
            this.previousEnd = 0;
            this.viewer.setText("");
            this.viewer.update();
        }
    }

    public String getText() {
        return this.viewer.getText();
    }

    @Override
    public IStatus initializeView(Display targetDisplay, IProgressMonitor monitor) {
        this.previousEnd = 0;
        this.viewer.setText("");
        this.viewer.update();
        return Status.OK_STATUS;
    }

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.addKillButton();
        this.addFileMenu();
        this.addHelpMenu();
        ViewFactory.addView(this);
    }

    @Override
    public void updateMethod() {
        String data;
        Object object = this.getParser().getData();
        if (object instanceof String && !(data = (String)object).isEmpty()) {
            this.prettyPrintln((String)this.getParser().getData());
        }
    }

    @Override
    public void setViewID() {
        this.viewID = "org.eclipse.linuxtools.callgraph.core.staptextview";
    }

    @Override
    protected boolean createOpenAction() {
        return false;
    }

    @Override
    protected boolean createOpenDefaultAction() {
        return false;
    }
}

