/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces;

import java.util.ArrayList;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;

public class ReferencedGrammarDiagnosticsInfo {
    private final String grammarURI;
    private final String grammarFileName;
    private final URIResolverExtensionManager resolverExtensionManager;
    private final Diagnostic diagnostic;
    private DOMDocument document;
    private int nbError;
    private boolean fatalError;

    public ReferencedGrammarDiagnosticsInfo(String grammarURI, URIResolverExtensionManager resolverExtensionManager, Diagnostic diagnostic) {
        this.grammarURI = grammarURI;
        this.grammarFileName = ReferencedGrammarDiagnosticsInfo.computeFileName(grammarURI);
        this.resolverExtensionManager = resolverExtensionManager;
        this.diagnostic = diagnostic;
        this.fatalError = false;
    }

    private static String computeFileName(String grammarURI) {
        if (grammarURI.startsWith("http")) {
            return grammarURI;
        }
        String fileName = grammarURI;
        int index = grammarURI.lastIndexOf(47);
        if (index == -1) {
            index = grammarURI.lastIndexOf(92);
        }
        if (index != -1) {
            fileName = grammarURI.substring(index + 1, grammarURI.length());
        }
        return fileName;
    }

    public void addDiagnosticRelatedInformation(DiagnosticRelatedInformation relatedInformation) {
        if (this.diagnostic.getRelatedInformation() == null) {
            this.diagnostic.setRelatedInformation(new ArrayList());
        }
        this.diagnostic.getRelatedInformation().add(relatedInformation);
    }

    public DOMDocument getGrammarDocument() {
        if (this.document == null) {
            this.document = DOMUtils.loadDocument(this.grammarURI, this.resolverExtensionManager);
        }
        return this.document;
    }

    private String getGrammarFileName() {
        return this.grammarFileName;
    }

    public void addError(boolean fatalError) {
        this.fatalError = fatalError;
        ++this.nbError;
        this.diagnostic.setMessage("There " + (this.nbError > 1 ? "are" : "is") + " '" + String.valueOf(this.nbError) + "' error" + (this.nbError > 1 ? "s" : "") + " in '" + this.getGrammarFileName() + "'.");
    }

    public boolean isFatalError() {
        return this.fatalError;
    }
}

