/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces.xmlmodel;

import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelHandler;

public class XMLModelAwareParserConfiguration
extends XIncludeAwareParserConfiguration {
    protected boolean xmlModelEnabled = true;
    private XMLModelHandler xmlModelHandler;

    public XMLModelAwareParserConfiguration() {
        this(null, null, null);
    }

    public XMLModelAwareParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public XMLModelAwareParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this(symbolTable, grammarPool, null);
    }

    public XMLModelAwareParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool, XMLComponentManager parentSettings) {
        super(symbolTable, grammarPool, parentSettings);
    }

    protected void configurePipeline() {
        super.configurePipeline();
        this.configureXMLModelPipeline();
    }

    protected void configureXML11Pipeline() {
        super.configureXML11Pipeline();
        this.configureXMLModelPipeline();
    }

    private void configureXMLModelPipeline() {
        if (this.xmlModelEnabled) {
            if (this.xmlModelHandler == null) {
                this.xmlModelHandler = new XMLModelHandler();
                this.addCommonComponent(this.xmlModelHandler);
                this.xmlModelHandler.reset((XMLComponentManager)this);
            }
            XMLDocumentSource prev = null;
            if (this.fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
                prev = this.fSchemaValidator.getDocumentSource();
            } else {
                prev = this.fLastComponent;
                this.fLastComponent = this.xmlModelHandler;
            }
            XMLDocumentHandler next = prev.getDocumentHandler();
            prev.setDocumentHandler((XMLDocumentHandler)this.xmlModelHandler);
            this.xmlModelHandler.setDocumentSource(prev);
            if (next != null) {
                this.xmlModelHandler.setDocumentHandler(next);
                next.setDocumentSource((XMLDocumentSource)this.xmlModelHandler);
            }
        }
    }
}

