/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lemminx.client.AbstractXMLNotifier;
import org.eclipse.lemminx.client.IXMLSettingFeature;
import org.eclipse.lemminx.client.PathFeature;
import org.eclipse.lemminx.services.IXMLNotificationService;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageType;

public class InvalidPathWarner
extends AbstractXMLNotifier {
    public InvalidPathWarner(IXMLNotificationService notificationService) {
        super(notificationService);
    }

    public void onInvalidFilePath(Set<String> invalidPaths, PathFeature feature) {
        if (this.existsInCache((IXMLSettingFeature)feature, invalidPaths)) {
            return;
        }
        this.sendInvalidFilePathWarning(invalidPaths, feature);
        this.setCacheValues(feature, new HashSet<String>(invalidPaths));
    }

    private void sendInvalidFilePathWarning(Set<String> invalidPaths, PathFeature feature) {
        String message = InvalidPathWarner.createWarningMessage(feature.getSettingId(), invalidPaths);
        Command command = new Command("Configure setting", "xml.open.settings", Collections.singletonList(feature.getSettingId()));
        super.sendNotification(message, MessageType.Error, command);
    }

    private static String createWarningMessage(String settingId, Set<String> invalidPaths) {
        StringBuilder message = new StringBuilder().append("Invalid path");
        if (invalidPaths.size() > 1) {
            message.append('s');
        }
        message.append(" for setting '").append(settingId).append("': ");
        ArrayList<String> list = new ArrayList<String>(invalidPaths);
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                message.append(", ");
            }
            message.append("'").append((String)list.get(i)).append("'");
        }
        return message.toString();
    }
}

